package cn.ac.csns.microscope.managed;

import cn.ac.csns.microscope.BL02DataStatus;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.PostConstruct;
import javax.faces.application.FacesMessage;
import javax.faces.context.FacesContext;
import javax.inject.Named;
import javax.faces.view.ViewScoped;
import javax.json.Json;
import javax.json.JsonArray;
import javax.json.JsonObject;
import javax.json.JsonReader;
import org.primefaces.json.JSONException;

/**
 *
 * @author tangm <a href="mailto:tangm@ihep.ac.cn">Tang Ming</a>
 */
@Named
@ViewScoped
public class BL02DataStatusController implements Serializable {

    private static final long serialVersionUID = 1L;
    private String msg = null;
    private String checkTime = null;
    private int updateInterval = 1;
    private Calendar updateTime;
    private boolean updating;
    private int transferredRunsNum;
    private final List<String> transferringRunList;
    private final List<BL02DataStatus> statusList;
    private List<BL02DataStatus> filteredStatusList;

    /**
     * Creates a new instance of BL02DataStatusController
     */
    public BL02DataStatusController() {
        transferringRunList = new ArrayList<>();
        statusList = new ArrayList<>();
    }

    @PostConstruct
    private void init() {
        updateTime = Calendar.getInstance();
        try (InputStream in = FacesContext.getCurrentInstance().getExternalContext()
                .getResourceAsStream("/data/bl02_data_status.json")) {
            if (null == in) {
                throw new IOException("Cannot load bl02_data_status.json");
            }
            JsonReader jsonReader = Json.createReader(in);
            JsonObject data = jsonReader.readObject();
            checkTime = data.getString("checkTime");
            transferredRunsNum = data.getInt("transferredRunsNum");

            JsonArray transferringRuns = data.getJsonArray("transferringRuns");
            if (null != transferringRuns) {
                transferringRuns.stream().forEach(item -> {
                    transferringRunList.add(item.toString());
                });
            }

            JsonArray dataStatus = data.getJsonArray("dataStatus");
            if (null != dataStatus) {
                dataStatus.stream().forEach(jsonObject -> {
                    statusList.add(parserDataStatus((JsonObject) jsonObject));
                });
            }
            statusList.sort((s1, s2) -> {
                return s2.getRun().compareToIgnoreCase(s1.getRun());
            });
        } catch (NullPointerException | ClassCastException | IOException | JSONException ex) {
            msg = ex.getMessage();
            Logger.getLogger(BL02DataStatusController.class.getName()).log(Level.SEVERE, ex.getMessage(), ex);
            FacesContext.getCurrentInstance().addMessage(null, new FacesMessage(FacesMessage.SEVERITY_ERROR, msg, msg));
        }
    }

    synchronized public void updateStatus() {        
        if (updating) {
            return;
        }
        updating = true;        
        transferringRunList.clear();
        statusList.clear();
        init();
        updating = false;
    }

    private BL02DataStatus parserDataStatus(JsonObject jsonObject) {
        String run = jsonObject.getString("run");
        BL02DataStatus dataStatus = new BL02DataStatus(run);
        JsonObject obj = jsonObject.getJsonObject("status");
        dataStatus.setControl(obj.getInt("ctrl"));
        dataStatus.setDetector(obj.getInt("daq"));
        dataStatus.setMonitor1_event(obj.getInt("mon1_evt"));
        dataStatus.setMonitor1_histogram(obj.getInt("mon1_his"));       
        dataStatus.setNexus(obj.getInt("nexus"));
        dataStatus.setSoftware(obj.getInt("software"));
        return dataStatus;
    }

    public Calendar getUpdateTime() {
        return updateTime;
    }

    public int getTransferredRunsNum() {
        return transferredRunsNum;
    }

    public int getUpdateInterval() {
        return updateInterval;
    }

    public void setUpdateInterval(int updateInterval) {
        this.updateInterval = updateInterval;
    }

    public String getCheckTime() {
        return checkTime;
    }

    public List<String> getTransferringRunList() {
        return transferringRunList;
    }

    public List<BL02DataStatus> getStatusList() {
        return statusList;
    }

    public List<BL02DataStatus> getFilteredStatusList() {
        return filteredStatusList;
    }

    public void setFilteredStatusList(List<BL02DataStatus> filteredStatusList) {
        this.filteredStatusList = filteredStatusList;
    }

}
