#!/usr/bin/env python3

from iMACS.Tasks import ManagedKafkaTask, ManagedRedisExpCfg
from iMACS.IO import ManagedRedis
from iMACS.Config import ConfigHelper
from iMACS.Tasks import TaskManager

import json,logging
import multiprocessing as mp
from time import sleep

logging.basicConfig(
    format='%(asctime)s %(levelname)-4s %(message)s',
    level=logging.INFO,
    datefmt='%Y-%m-%d %H:%M:%S')

from mpi_test_cfg import getConfigure

gen = getConfigure()

fname='test_config.json'
gen.saveAs(fname)

detCount=mp.Value('d',0)
monitorCount=mp.Value('d',0)
ctrl=mp.Value('i', 0)

tasks = {}
chlp = ConfigHelper(fname)
cfgItems= chlp.getValue('Managed')
print(cfgItems[1])
ctl = eval(cfgItems[1].get('class_name'))(cfgItems[1], sharedControl = ctrl, sharedNumHit=detCount, sharedAccumulated=monitorCount )
ctl.start()
print(f'started item2')


for i in range(2,23):
    hist = eval(cfgItems[i].get('class_name'))(cfgItems[i], sharedControl = ctrl, sharedNumHit=detCount )
    hist.start()
    print(f'started item{i}')



while True:
    # with ctrlLock:
    #     if ctrl.value==1:
    #         ctrl.value = 0
    #     else:
    #         ctrl.value = 1
    print(f'ctrl {ctrl.value}, total {detCount.value}')
    sleep(1)
