import baseOP
import json
import time
import matplotlib.pyplot as plt

confFile='conf.json'
with open(confFile,'r') as jFile:
    conf_info=json.load(jFile)
rds=baseOP.getRedisHelper(conf_info["redis_data"])
on_conf=conf_info["online_configure"]

path=on_conf["llPath"]

#bank
def plotBankData(dataname,group):
    path_bank=path+"/"+group+"/raw/"+dataname
    try:
        x=rds.readNumpyArray(path_bank)
    except:
        print(path_bank)
    path_bank=path+"/"+group+"/raw/"+dataname+"_counts"
    y=rds.readNumpyArray(path_bank)
    plt.plot(x,y)
    plt.show()

#module
def plotModuleData(dataname,name):
    path_m=path+"/"+name+"/"+dataname
    x=rds.readNumpyArray(path_m)
    path_m=path+"/"+name+"/"+dataname+"_counts"
    y=rds.readNumpyArray(path_m)
    plt.plot(x,y)
    plt.show()
    
def plotMonitorData(dataname):
    path_w=path+"/monitor1/"+dataname
    x=rds.readNumpyArray(path_w)
    path_w=path+"/monitor1/"+dataname+"_counts"
    y=rds.readNumpyArray(path_w)
    plt.plot(x,y)
    plt.show()

def plotImage(name):
    path0=path+"/"+name+"/xy_image/x"
    x=rds.readNumpyArray(path0)
    path0=path+"/"+name+"/xy_image/y"
    y=rds.readNumpyArray(path0)
    path0=path+"/"+name+"/xy_image/value"
    z=rds.readNumpyArray(path0)
    print(x.shape,y.shape,z.shape)
    plt.pcolormesh(x,y,z)
    plt.colorbar()
    plt.show()
import sys

module="module"+sys.argv[1]
#group="group"+sys.argv[1]
#plotBankData("d",group)
#plotModuleData("tof",module)
#plotMonitorData("tof")
plotImage(module)
