from mantid.simpleapi import *
import threading
import numpy as np


class moduleIO(threading.Thread):
    def __init__(self,neonRedis, refreshtime, module, pidNum):
        super(moduleIO, self).__init__()

        self.refreshtime=refreshtime
        self.neonRedis=neonRedis
        self.module=module
        self.pidNum=pidNum
        self.histPath="/MPI/workspace/detector/"+self.module+"/value"
        self.instPath="./paramData/"+self.module+".xml"
        self.sendPath="/MPI/workspace/MantidData/"+self.module
        self.tofs=[]
        for i in range(2500):
            self.tofs.append(i*16)
        self.tofs=np.array(self.tofs)

    def processWS(self):
        CreateWorkspace(OutputWorkspace=self.module, DataX=self.tofs, DataY=self.value, NSpec=self.pidNum, UnitX='TOF', VerticalAxisUnit='SpectraNumber')
        LoadInstrument(Workspace=self.module, Filename=self.instPath, RewriteSpectraMap='True')
        ConvertUnits(InputWorkspace=self.module, OutputWorkspace=self.module+'_d', Target='dSpacing', EMode='Elastic', AlignBins = True)
        SumSpectra(InputWorkspace=self.module+'_d', OutputWorkspace=self.module+'_d')
        ConvertToPointData(InputWorkspace=self.module+'_d', OutputWorkspace=self.module+'_d')
    
    def sendData(self):
        name=mtd[self.module+"_d"]
        y=name.readY(0)
        x=name.readX(0)
        path=self.sendPath+"/d"
        self.neonRedis.writeNumpyArray(path,x)
        path=self.sendPath+"/intensity"
        self.neonRedis.writeNumpyArray(path,y)
        

    def process(self):
        self.value = self.neonRedis.readNumpyArray(self.histPath)
        self.processWS()
        self.sendData()

    def run(self):
        while True:
            self.process()
            time.sleep(2)
