
from iMACS.Config import KafkaConfig, HistConfig, RedisConfig, RedisRWConfig, ConfigHelper
import json

class ConfigGenerator(ConfigHelper):
    def __init__(self):
        super().__init__({})
        self.keyMap={}
        self.keyMap['Kafka'] = KafkaConfig
        self.keyMap['Histogram'] = HistConfig
        self.keyMap['Redis'] = RedisConfig
        self.keyMap['RedisRW'] = RedisRWConfig


    def reset(self):
        self.cfg={}

    def addConfig(self, cfgobj):
        supportedType = False
        for key, objectType in self.keyMap.items():
            if type(cfgobj) is objectType:
                if self.getValue(key) is None:
                    self.cfg[key] = []
                self.cfg[key].append(cfgobj.getDict())
                supportedType=True
        if not supportedType:
            raise Exception(f'ConfigGenerator unsupported {type(cfgobj)}')

    def getConfig(self):
        return self.cfg

    def saveAs(self, fileName):
        with open(fileName, 'w') as outfile:
            json.dump(self.cfg, outfile, indent = 2)
