import json

#config classes should raise error if an unknown key is given
class ConfigBase():
    def __init__(self):
        self.__config={}

    def __setWithoutCheck(self, **kwargs):
        for key, value in kwargs.items():
            self.__config[key] = value

    def set(self, **kwargs):
        for key, value in kwargs.items():
            if key in self.__config:
                self.__config[key] = value
            else:
                raise RuntimeError(f'key {key} is not a valid parameter in cfg class {type(self)}')

    def getDict(self, check=True):
        if check:
            for key, value in self.__config.items():
                if value is None:
                    raise RuntimeError(f'key {key} is undefined in a cfg object {type(self)}')
        return self.__config

    def getJson(self, check=True):
        return json.dumps(self.getDict(check), indent = 2)


class KafkaConfig(ConfigBase):
    def __init__(self):
        super().__init__()
        #set defult paramters
        self._ConfigBase__setWithoutCheck(auto_offset_reset='earliest', consumer_timeout_ms='inf',\
            enable_auto_commit = True, bootstrap_servers=None, data_type = None, \
            topic = None, group_id = None, seek_type = None, histogram='' )

class HistConfig(ConfigBase):
    def __init__(self):
        super().__init__()
        #set defult paramters
        self._ConfigBase__setWithoutCheck(xBinNum=None,  xmin=None, xmax=None,  \
            yBinNum = None,  ymin = None, ymax=None, redis_rw='')

class RedisConfig(ConfigBase):
    def __init__(self):
        super().__init__()
        #set defult paramters
        self._ConfigBase__setWithoutCheck(servers = None, password = None, master_name = None, db=None)


class RedisRWConfig(ConfigBase):
    def __init__(self):
        super().__init__()
        #set defult paramters
        self._ConfigBase__setWithoutCheck(redis_server_idx=0, target=None, redisPath=None, mode=None, \
            asNumArray=None, update_interval_sec=None)
