from iMACS.Config import KafkaConfig, HistConfig, RedisConfig, RedisRWConfig, ConfigGenerator,ConfigHelper

def genRedisConfig():
    #redis
    rdisConfObj=RedisConfig()
    rdisConfObj.set(class_name='ManagedRedis')
    rdisConfObj.set(password='sanlie_123') #set a single parameter
    rdisConfObj.set(master_name='mpi_redis_master', db=0) #or multiple parameters
    servers= [("10.1.37.241","26379"),("10.1.37.246","26379"),("10.1.37.247","26379")]

    rdisConfObj.set(servers=servers, socket_timeout=100)
    return rdisConfObj


def genMonitorConfig(rdisConfObj):
    #histogram redis
    rRW = RedisRWConfig()
    rRW.set(class_name='None a class')
    rRW.set(redis_info=rdisConfObj.getDict())
    rRW.set(update_interval_sec=5)

    updateTarget=[]
    updateTarget.append({'redisPath': '/MPI/workspace/monitor1/value', \
                         'data':'self.hist', \
                         'mode': 'wnp' })

    updateTarget.append({'redisPath': '/mpi/imacs/monitor_counts', \
                         'data':'self.hist.sum()', \
                         'mode': 'w' })
    rRW.set(target=updateTarget)


    #histogram
    histCfgObj = HistConfig()
    histCfgObj.set(class_name='ManagedHistRedis')
    histCfgObj.set(xBinNum=40000)
    histCfgObj.set(xmin=-0.5)
    histCfgObj.set(xmax=40000-0.5)

    histCfgObj.set(yBinNum=1)
    histCfgObj.set(ymin=0)
    histCfgObj.set(ymax=1e10)
    histCfgObj.set(redis_readwrite=rRW.getDict())

    #kafka
    kfkCfgObj = KafkaConfig()
    kfkCfgObj.set(class_name='ManagedKafkaTask')
    kfkCfgObj.set(bootstrap_servers=[ \
                        "10.1.37.205:9092",\
                        "10.1.37.206:9092",\
                        "10.1.37.207:9092",\
                        "10.1.37.208:9092"])
    kfkCfgObj.set(data_type='event')
    kfkCfgObj.set(topic='BL16-Monitor01-EventData')
    kfkCfgObj.set(group_id = 'durong_test', seek_type='beginning' )
    kfkCfgObj.set(histogram=histCfgObj.getDict())
    return kfkCfgObj


def genGlobalConfig(rdisConfObj):



def genDetectorConfig(rdisConfObj, bank, module):
    pixelNum=800
    if bank==7 or bank==8:
        pixelNum=480


    #histogram redis
    rRW = RedisRWConfig()
    rRW.set(class_name='None a class')
    rRW.set(redis_info=rdisConfObj.getDict())
    rRW.set(update_interval_sec=5)

    moduleID=int(1e4+bank*1e2+module)
    updateTarget=[]
    updateTarget.append({'redisPath': f'/MPI/workspace/detector/module{moduleID}/value', \
                         'data':'self.hist', \
                         'mode': 'wnp' })

    updateTarget.append({'redisPath': f'/mpi/imacs/detector_counts/module{moduleID}', \
                         'data':'self.hist.sum()', \
                         'mode': 'w' })
    rRW.set(target=updateTarget)

    minPixelID= 1e8 + bank*1e6 + module * 1e4

    #histogram
    histCfgObj = HistConfig()
    histCfgObj.set(class_name='ManagedHistRedis')
    histCfgObj.set(xBinNum=2500)
    histCfgObj.set(xmin=-0.5)
    histCfgObj.set(xmax=40000-0.5)

    histCfgObj.set(yBinNum=pixelNum)
    histCfgObj.set(ymin=minPixelID+0.5)
    histCfgObj.set(ymax=minPixelID+0.5+pixelNum)
    histCfgObj.set(redis_readwrite=rRW.getDict())

    #kafka
    kfkCfgObj = KafkaConfig()
    kfkCfgObj.set(class_name='ManagedKafkaTask')
    kfkCfgObj.set(bootstrap_servers=[ \
                        "10.1.37.205:9092",\
                        "10.1.37.206:9092",\
                        "10.1.37.207:9092",\
                        "10.1.37.208:9092"])
    kfkCfgObj.set(data_type='event')
    kfkCfgObj.set(topic=f'BL16-Detector-tmp5-Bank{bank}-Module{module}-EventData')
    kfkCfgObj.set(group_id = 'durong_test', seek_type='beginning' )
    kfkCfgObj.set(histogram=histCfgObj.getDict())
    return kfkCfgObj

def genControlConfig(rdisConfObj):
    rRW = RedisRWConfig()
    rRW.set(class_name='ManagedRedisExpCfg')
    rRW.set(redis_info=rdisConfObj.getDict())
    rRW.set(update_interval_sec=1)
    updateTarget=[]
    updateTarget.append({'redisPath': '/mpi/control/runInfo', \
                         'data':'self.redisData', \
                         'mode': 'r' })

    updateTarget.append({'redisPath': '/mpi/imacs/detector_counts', \
                         'data':'self.dectCnt', \
                         'mode': 'w' })

    updateTarget.append({'redisPath': '/mpi/imacs/detector_rates', \
                         'data':'self.dectCntRate', \
                         'mode': 'w' })

    updateTarget.append({'redisPath': '/mpi/imacs/monitor_counts', \
                         'data':'self.monitorCnt', \
                         'mode': 'w' })

    updateTarget.append({'redisPath': '/mpi/imacs/monitor_rates', \
                         'data':'self.monitorCntRate', \
                         'mode': 'w' })

    rRW.set(target=updateTarget)
    return rRW


def getConfigure():
    gen = ConfigGenerator()

    redisCfg = genRedisConfig()
    gen.addConfig(redisCfg)
    gen.addConfig(genControlConfig(redisCfg))

    detector_modules = ['0804', '0803', '0802', '0801', '0701', '0702', '0703', '0704', '0903', '0902', '0602', '0603', '1005', '1004', '1003', '1002', '0502', '0503', '0504', '0505']
    for mid in detector_modules:
        gen.addConfig(genDetectorConfig(redisCfg,mid[0:2], mid[2:]))

    gen.addConfig(genMonitorConfig())
    gen.addConfig(genGlobalConfig())
    return gen
