import pathlib
import os
import json
import logging

class ConfigHelper:
    def __init__(self, file_path=None):
        self.file_path = file_path
        self.conf_file = self._determinate_conf_file()
        with open(self.conf_file, 'r') as _f:
            self.conf = json.load(_f)

    def _determinate_conf_file(self):
        _confF = ''

        if self.file_path is not None:
            _confF = self.file_path
        else:
            try:
                os.environ['IMACSPATH']
            except KeyError:
                raise Exception('IMACSPATH is not set in your enviorment. Source iMACS steup.sh before continue.')
            _base = os.environ['IMACSPATH']
            _confF = pathlib.Path.joinpath(_base, 'conf/conf.json')

        if _confF.is_file():
            return _confF.as_posix()

        raise Exception('No conf.json found')

    def getValue(self, akey):
        try:
            return self.conf[akey]
        except KeyError:
            logging.debug(f'Key {akey} is not available in the dict')
            return None

    def getConfFile(self):
        return self.conf_file

    def getConf(self):
        return self.conf

    def writeConf2Redis(self, redisHelper, key, conf):
        return redisHelper.write(key, json.dumps(conf))

    def getConfFromRedis(self, redisHelper, key):
        return json.loads(redisHelper.read(key))
