#!/usr/bin/env python3

from Utils.Histogram import Hist2D
from Utils.cHistogram import NumpyHist2D

import numpy as np
import time

xbin=4000
ybin=500

# hist = Hist2D(xbin,ybin,[[0,1],[0,1]])
histSlow = Hist2D(xbin,ybin,[[0,1],[0,1]])
hist = NumpyHist2D(xbin,ybin,[[0,1],[0,1]])

eventSize = 100

for i in range(100):
    data=np.random.random([2,eventSize])
    now = time.time()
    hist.fill(data[0],data[1])
    els = time.time()-now

    now = time.time()
    histSlow.slowfill(data[0],data[1])
    elsSlow = time.time()-now

    np.testing.assert_array_equal(hist.getHistVal(), histSlow.hist)

    print('{} events, fast fill {:5.2f}ms ({:5.2f}us per event), slow fill {:5.2f}ms'.format(eventSize, els*1e3, els*1e6/eventSize, elsSlow*1e3) )
