#!/bin/bash

#remove previously sourced env
function imacs_prunepath() {
    P=$(IFS=:;for p in ${!1}; do [[ $p != ${2}* ]] && echo -n ":$p" || :; done)
    export $1=${P:1:99999}
}

if [ ! -z ${IMACSPATH:-} ]; then
    imacs_prunepath PATH "$IMACSPATH"
    imacs_prunepath PYTHONPATH "$IMACSPATH"
    echo "Cleaned up previously defined IMACS enviorment"
fi

unset imacs_prunepath

export IMACSPATH="$( cd -P "$( dirname "${BASH_SOURCE[0]}" )" && pwd )"

if [ -f $IMACSPATH/python/__init__.py ]; then
  export PYTHONPATH="$IMACSPATH/python:$PYTHONPATH"
fi
