
import multiprocessing as mp
from abc import ABC, abstractmethod

class Task(ABC, mp.Process):
    def __init__(self, status, detRat=mp.Value('d',0.0)):
        mp.Process.__init__(self)
        self.status = status
        self.detcnt = detRat

    @abstractmethod
    def run(self):
        pass

class EpicsListener(Task):
    def __init__(self, status):
        super().__init__(status)
        pass

class EpicsWriter(Task):
    def __init__(self, status):
        super().__init__(status)
        pass

class RedisTask(Task):
    def __init__(self, status):
        super().__init__(status)
        pass

class DataBaseTask(Task):
    def __init__(self, status):
        super().__init__(status)
        pass
