import time, datetime
from IO.RedisHelper import RedisHelper
import reckafka
from IO.Kafka import getDetectorData, getGlobalData, KafkaGrabber
import re
import os

def createDir(path):
    if os.path.exists(path):
        pass
    else:
        os.mkdir(path)

def getRedisHelper(redis_conf):
    _mode = redis_conf['mode'].lower()
    _password = redis_conf['password']
    _servers = []
    for _item in redis_conf['servers']:
        _servers.append((_item['host'], _item['port']))

    if _mode == 'standalone':
        return RedisHelper(_servers[0], _password, 10)
    elif _mode == 'sentinel':
        return RedisHelper(_servers, _password, 10, master_name=redis_conf['master_name'])
    else:
        raise Exception(f'Redis mode not supported: {_mode}')

def getModuleName(conf):
    _topic = conf['topic']
    _pattern = '^BL16-Detector-(Bank\d{2}-Module\d{2})-EventData$'
    _r = re.match(_pattern, _topic)
    _p = None
    if _r is not None:
        _p = _r.group(1)
    _p="module1"+_p[4:6]+_p[-2:]
    return _p

def onlineDetector(conf,hours,mname,prepath,xmlPath):
    offset=25*60*60*hours
    task = KafkaGrabber(conf, offset)
    consumer=task.getKafkaConsumer()
    nxsfile=prepath+"/"+mname+".nxs"
    run = reckafka.dataSvc(consumer, xmlPath)
    run.recEvtNxs(nxsfile,mname,0,9999999999)


class timeConvert():
    def __init__(self):
        self.local_format="%Y-%m-%dT%H:%M:%S"
        self.startSecond=1609430400.0
        self.startLocal="2021-01-01T00:00:00"
        self.startPulseId=214246007

    def utc_stamp_to_local(self,seconds):
        utc_time=datetime.datetime.utcfromtimestamp(seconds)
        local=utc_time+datetime.timedelta(hours=8)
        local=local.strftime(self.local_format)
        return local

    def local_to_utc_stamp(self,local):
        dt=datetime.datetime.strptime(local, self.local_format)
        dt=dt+datetime.timedelta(hours=-8)
        stamp=time.mktime(dt.timetuple())
        return stamp
    
    def local2PulseId(self,local):
        ts = self.local_to_utc_stamp(local)
        offset = ts-self.startSecond
        pId = int(offset*25+self.startPulseId)
        return pId

    def pulseId2Local(self, pId):
        local = self.utc_stamp_to_local(self.startSecond+(pId-self.startPulseId)/25)
        return local
