#!/usr/bin/env python3

from IO.Kafka import getDetectorData, getGlobalData, KafkaGrabber
from Utils.Histogram import Hist2D
from Tasks.TaskManager import TaskManager
from IO.RedisHelper import RedisHelper

from time import sleep
import multiprocessing as mp
import time
import numpy as np
import logging

logging.basicConfig(level=logging.INFO)



def onlineDetector(conf):
    print('onlineDetector is running')
    redisPath='/MPI/workspace/detector/module02/value'
    ip_port = ('10.1.36.57', 6379)
    passwd = 'sanlie_123'
    appName='Bank2 module02'

    rds= RedisHelper(ip_port, passwd, 10)

    tofBinSize = 2500
    pixBinSize=800//2

    hist = Hist2D(tofBinSize, pixBinSize,[[0-0.5,40000-0.5],[102020001-0.5, 102020001+0.5+800]])
    task = KafkaGrabber( conf['detector_modules'][1], 100000)
    consumer = task.getKafkaConsumer()
    dataType = task.getDataType()
    startTime=time.time()
    i=int(0)
    startPulseID=0
    for msg in consumer:
        i+=int(1)
        pulseStart=time.time()
        pulseId, tof, pid = getDetectorData(msg)
        if startPulseID==0:
            startPulseID=pulseId
        # print(pulseId, tof.shape, pid.min(), pid.max())

        if not tof.size*pid.size:
            logging.warning('data with zero size')
            continue
        if tof.size != pid.size:
            logging.warning('tof and pid arrays differ in size')
            continue

        if not hist.fill(tof, pid):
            print(tof)
            print(pid)
            print('tof type', type(tof), tof.size)
            print('pid type', type(pid), pid.size)
            print('tof range', tof.min(),tof.max())
            print('pid range', pid.min(),pid.max() )
            logging.warning('{} contains invalid data, range of tof(), range of pid{}'.format(\
                            appName, (tof.min(),tof.max()), (pid.min(),pid.max()) ))
            return

        pulseEnd=time.time()

        if i==int(2500):

            i=int(0)
            rds.writeNumpyArray(redisPath, hist.hist)
            # data_back=rds.readNumpyArray(redisPath)
            # np.testing.assert_array_equal(hist.hist,data_back)
            # print('passed redis numpy read write test')
            redisTime=time.time()
            totEvent = hist.hist.sum()
            logging.info('pulse processing time {:5.2f}ms, histogram accumulated {}, rate {:5.2f}kHz, redis {:5.2f}ms'.format((pulseEnd-pulseStart)*1e3, totEvent, \
                          totEvent/((pulseId-startPulseID)*40.), 1e3*(redisTime-pulseEnd)  ))

conf={'detector_modules':[{'data_type':'meta','bootstrap_servers':['10.1.29.120:9092'], 'auto_offset_reset':'earliest','group_id':'mpi_das', 'topic':'PulseBeam', 'enable_auto_commit': True, 'consumer_timeout_ms':5000}, {'data_type':'event','bootstrap_servers':['10.1.36.82:9092'], 'auto_offset_reset':'earliest','group_id':'das_test', 'topic':'BL16-Detector-Bank02-Module02-EventData', 'enable_auto_commit': True, 'consumer_timeout_ms':5000}]}
# onlineDetector(conf)
if __name__ == '__main__':
    mp.set_start_method('fork')

    tasks = {'det': [onlineDetector, (conf,)]}
    man = TaskManager(tasks)
    print("main thread sleeping")
    sleep(100000000)
    man.stopProc()
    print ('Main exit')
