#!/usr/bin/env python3

from iMACS.Tasks import ManagedEpics
import numpy as np
from time import sleep
import os

redis_cfg = {
  "class_name": "ManagedRedis",
  "servers": [
    [
      "10.1.37.239",
      "6379"
    ]
  ],
  "password": "sanlie_123",
  "master_name": "mpi_redis_master",
  "db": 0,
  "socket_timeout": 100
}

pvlist=[{
'pv_name': 'EXP_IB1_MPI:SAM:CHG1:SamNum:ao',
'alias': 'sample_number',
'rw_mode': 'r',
'write_value' : 1,
'redis_path' : 'redis/r/EXP_IB1_MPI:SAM:CHG1:SamNum:ao',
'valid_range' : [1, 16],
'veto' : True
},
{
'pv_name': 'EXP_IB1_MPI:SAM:CHG1:SamNum:ao',
'alias': 'sample_number',
'rw_mode': 'w',
'write_value' : 5,
'redis_path' : 'redis/w/EXP_IB1_MPI:SAM:CHG1:SamNum:ao',
'valid_range' : [1, 16],
'veto' : True
}]

os.environ['EPICS_CA_ADDR_LIST']='10.1.37.218:6003'  # Sample Changer

myepics = ManagedEpics(redis_cfg, pvlist)
data=np.arange(10)
datapath='xx/testepsic/numpy'
myepics.writeNumpyArray(datapath, data)
print(myepics.readNumpyArray(datapath))

while True:
    sleep(1)
    print('from redis (read), ', myepics.read('redis/r/EXP_IB1_MPI:SAM:CHG1:SamNum:ao'))
    print('from redis (write), ', myepics.read('redis/w/EXP_IB1_MPI:SAM:CHG1:SamNum:ao'))
    print('from redis (read), ', myepics.read('redis/r/EXP_IB1_MPI:SAM:CHG1:SamNum:ao'))
