
from abc import ABC, abstractmethod
import flatbuffers
from kafka import KafkaConsumer, TopicPartition
import Data.Detector.EventData
import Data.Detector.MetaData
import numpy as np


class Task(ABC):
    def __init__(self, queue):
        self.queue = queue

    @abstractmethod
    def get(self, pars):
        pass

    @abstractmethod
    def set(self):
        pass


class KafkaGrabber(Task):
    def __init__(self, queue, conf):
        super().__init__(queue)
        if type(conf) is not dict:
            raise Exception('Error: conf must be a dict')
        self.conf = conf
        self.previousPulseId = None
        self.dataType = self.conf['data_type']

    def getKafkaConsumer(self):
        consumer = KafkaConsumer(group_id=self.conf['group_id'],
                bootstrap_servers=self.conf['bootstrap_servers'],
                auto_offset_reset=self.conf['auto_offset_reset'],
                enable_auto_commit=self.conf['enable_auto_commit'],
                consumer_timeout_ms=self.conf['consumer_timeout_ms'])
        #consumer.subscribe(topics=[self.conf['topic']])
        consumer.assign([TopicPartition(self.conf['topic'], 0)])

        return consumer
    def getDataType(self):
        return self.dataType

    def get(self, pars):
        pass

    def set(self):
        pass

class EpicsListener(Task):
    def __init__(self, queue):
        super().__init__(queue)
        pass

class EpicsWriter(Task):
    def __init__(self, queue):
        super().__init__(queue)
        pass

class RedisTask(Task):
    def __init__(self, queue):
        super().__init__(queue)
        pass

class DataBaseTask(Task):
    def __init__(self, queue):
        super().__init__(queue)
        pass
