
import flatbuffers
from kafka import KafkaConsumer, TopicPartition
import Data.Detector.EventData
import Data.Detector.MetaData
import numpy as np
from Tasks.Task import KafkaGrabber

def checkPulseId(previousPulseId, currentPulseId):
    if previousPulseId is not None:
        _inc = currentPulseId - previousPulseId
        if _inc > 1:
            print(f'[WARN] pulseId not continueous: pre {previousPulseId}, cur {currentPulseId}')
            return false
        return True
    return True

def decodeEventData(msg):
    _data = Data.Detector.EventData.EventData.GetRootAsEventData(msg.value, 0)
    _pulseId = _data.PulseId()
    _tofs = _data.TofAsNumpy()
    _pids = _data.PosAsNumpy()
    _events = np.c_[_pids, _tofs]
    return _tofs, _pids

def decodeMetaData(msg):
    _data = Data.Detector.MetaData.MetaData.GetRootAsMetaData(msg.value, 0)
    _pulseId = _data.PulseId()
    _deviceId = _data.DeviceId()
    _deviceName = _data.DeviceName()
    _value = _data.ValueAsNumpy()
    _timeNano = _data.TimeNanoAsNumpy()
    _timeSecond = _data.TimeSecondAsNumpy()
    return _pulseId, _value, _timeNano, _timeSecond

def run(conf, queue=None):
    kafkaGrabber = KafkaGrabber(queue, conf)
    consumer = kafkaGrabber.getKafkaConsumer()
    dataType = kafkaGrabber.getDataType()
    for msg in consumer:
       tofs, pids = decodeEventData()

