import h5py
import numpy as np
import os
import time
import datetime


pubName = ["beamline","description","measurement_type","proposal_id","proton_charge","run_no","version","wavelength","start_time_tai","start_time_utc","end_time_tai","end_time_utc","instrument_bank_definition","instrument_bank_file","instrument_name"]

def writeFileAttrs(f_nxs,fName):
    f_nxs.attrs["default"]="entry"
    f_nxs.attrs["file_name"]=fName
    timestamp = str(datetime.datetime.now())
    f_nxs.attrs["file_time"]=timestamp
    f_nxs.attrs["NeXus_Version"]="4.3.0"
    f_nxs.attrs["HDF5_Version"]="1.8.12"


def writeEntry(f_nxs):
    root = f_nxs.create_group("csns")
    root.attrs["NX_class"] = "NXentry"
    return root


def writePublic(f_nxs, pubDict):
    entry = writeEntry(f_nxs)
    for key in pubDict: 
        entry.create_dataset(key, data = pubDict[key])

def writeUser(f_nxs,userDict):
    grp = f_nxs.create_group("/csns/user")
    grp.attrs["NX_class"] = "NXuser"
    for key in userDict:
        grp.create_dataset(key, data = userDict[key])

def writeProcess(f_nxs, proDict):
    grp = f_nxs.create_group("/csns/process")
    grp.attrs["NX_class"] = "NXprocess"
    for key in proDict:
        grp.create_dataset(key, data = proDict[key])

def writePresentData(f_nxs):
    grp = f_nxs.create_group("/csns/present_data")
    grp.attrs["NX_class"] = "NXxxx"

def writeLog(f_nxs):
    pass

def writeInst(f_nxs):
    grp = f_nxs.create_group("/csns/instrument")
    grp.attrs["NX_class"] = "NXinstrument"
    grp2= grp.create_group("moderator")
    grp2.attrs["NX_class"] = "NXmoderator"

def writeInst_Module(f_nxs,moduleName,pidData,tofData,pulseData):
    grp = f_nxs.create_group("/csns/instrument")
    grp.attrs["NX_class"] = "NXinstrument"
    grp2= grp.create_group(moduleName)
    grp2.attrs["NX_class"] = "NXdetector"
    ds=grp2.create_dataset("event_pixel_id",dtype="int64",compression="gzip", data=pidData)
    ds=grp2.create_dataset("event_pulse_time",dtype="int64",compression="gzip", data=pulseData)
    ds=grp2.create_dataset("event_time_of_fligth",dtype="int64",compression="gzip", data=tofData)

def writeInst_moderator(grp_inst, moderatorDict):
    grp = grp_inst.create_group("moderator")
    grp.attrs["NX_class"] = "NXmoderator"
    grp.create_dataset("type", data = moderatorTpye)
    ds = grp.create_dataset("distance", data = moderatorDict["distance"])
    ds.attrs["units"] = "m"
    ds = grp.create_dataset("temperature", data = moderatorDict["temperature"])
    ds.attrs["units"] = "K"



