import flatbuffers
from kafka import KafkaConsumer, TopicPartition
import Data.Global.MetaData
import numpy as np
import signal
from datetime import datetime
import sys, time, calendar, pytz


def createKafkaConsumer():
    consumer = KafkaConsumer(group_id='mpi_das', bootstrap_servers=['10.1.29.120:9092'], auto_offset_reset='earliest', enable_auto_commit=True, consumer_timeout_ms=5000)
    topic = 'PulseBeam'
    #partition = TopicPartition(topic, 0)
    #consumer.assign([partition])
    consumer.subscribe([topic])
    return consumer

def seekToOffset(consumer, partition, offset):
    #consumer.seek_to_beginning()
    #consumer.seek_to_end()
    consumer.seek(partition, offset)
    #print(consumer.position(partition))

def parseMessage(msg):
    _data = Data.Global.MetaData.MetaData.GetRootAsMetaData(msg.value, 0)
    _pulseId = _data.PulseId()
    _deviceId = _data.DeviceId()
    _deviceName = _data.DeviceName()
    _value = _data.ValueAsNumpy()
    _timeNano = _data.TimeNanoAsNumpy()
    _timeSecond = _data.TimeSecondAsNumpy()
    return _pulseId, _value, _timeSecond, _timeNano

consumer = createKafkaConsumer()

def sigint_handler(signum, frame):
    consumer.commit()
    consumer.close()
    print(f'End pulse id: {end_pulseId}, at unix second: {end_timeSecond}')
    sys.exit(0)

def local2utc(local):
    # Local datatime string to utc seconds.
    #local='2018-03-26T15:28:42'
    dateTimeString='%Y-%m-%dT%H:%M:%S'
    localTimeZone = pytz.timezone("Asia/Shanghai")
    localTime = datetime.strptime(local, dateTimeString)
    local_dt = localTimeZone.localize(localTime, is_dst=None)
    utc_dt = local_dt.astimezone(pytz.utc)
    utcSecond = calendar.timegm(utc_dt.timetuple())
    return utcSecond



original_sigint_handler=signal.signal(signal.SIGINT, sigint_handler)

#'''
msg_pack = consumer.poll(timeout_ms=5000, max_records=1, update_offsets=False)
'''
for _k, _v in msg_pack.items():
    if len(_v) > 0:
        msg = _v[0]
        start_pulseId, _, start_timeSecond, _ = parseMessage(msg)
        print(f'Start pulse id: {start_pulseId}, at unix second: {start_timeSecond}')
'''
#sys.exit(0)

#topics = consumer.topics()
topic = 'PulseBeam'
topicPartitions = consumer.partitions_for_topic(topic)
partition = list(consumer.assignment())[0]
offset = consumer.position(partition)
print(f'Next Start offset: {offset}')
consumer.seek_to_end()
offset = consumer.position(partition)
consumer.seek(partition, offset-25*60*30)


local='2020-12-09T10:50:00'
utcsecond=local2utc(local)

bt = time.time()
for msg in consumer:
    _data = Data.Global.MetaData.MetaData.GetRootAsMetaData(msg.value, 0)
    _timeSecond = _data.TimeSecondAsNumpy()[0]
    #print(_timeSecond)
    if _timeSecond==utcsecond:
        _pulseId = _data.PulseId()
        print(_pulseId,local)
    
        consumer.close()
