from iMACS.IO import RedisPeriodicRW
from iMACS.Utils.Histogram import Hist2D
from iMACS.Config import ConfigHelper

class ConfigHist2D(Hist2D):
    def __init__(self, histCfg):
        cfgobj = ConfigHelper(histCfg)
        xBinNum = cfgobj.getValue('xBinNum' )
        yBinNum = cfgobj.getValue('yBinNum' )
        xmin = cfgobj.getValue('xmin' )
        xmax = cfgobj.getValue('xmax' )
        ymin = cfgobj.getValue('ymin' )
        ymax = cfgobj.getValue('ymax' )
        super().__init__(xBinNum , yBinNum, [[xmin, ymax], [xmin, ymax]])


#HistRedis.start() start periodic redis operations
#HistRedis.stop() stop the operation
class HistRedis(ConfigHist2D, RedisPeriodicRW):
    def __init__(self, cfg):
        #super().__init__(cfg)
        ConfigHist2D.__init__(self, cfg)
        RedisPeriodicRW.__init__(self, cfg.get('redis_readwrite'))
        self.target=self.hist
