import pathlib
import os
import json
import logging

#data can be the path of a json file or a dict object

#if data is empty, config in $IMACSPATH/conf/conf.json
class ConfigHelper:
    def __init__(self, data=None):
        if type(data) is dict:
            self.conf = data
        else:
            with open(self.determinate_config_file(data), 'r') as _f:
                self.conf = json.load(_f)

    def determinate_config_file(self, data):
        confF = ''
        if data is not None:
            confF = data
        else:
            try:
                os.environ['IMACSPATH']
            except KeyError:
                raise Exception('IMACSPATH is not set in your enviorment. Source iMACS steup.sh before continue.')
            pbase = os.environ['IMACSPATH']
            confF = pathlib.Path.joinpath(pbase, 'conf/conf.json')
        return confF

    def getValue(self, *keys):
        if len(keys)==0:
            raise Exception('ConfigHelper.getValue with empty key.')
        stuff = self.conf.get(keys[0])
        for i in range(1,len(keys)):
            if type(stuff) is not dict:
                return None
            stuff = stuff.get(keys[i])
        return stuff

    def writeConf2Redis(self, redisHelper, key, conf):
        return redisHelper.write(key, json.dumps(conf))

    def getConfFromRedis(self, redisHelper, key):
        return json.loads(redisHelper.read(key))
