from IO.RedisHelper import RedisHelper
import json
import baseOP
import sys
import numpy as np
import time
import baseComp
import subprocess
import datetime
import glob

def getRedisHelper(redis_conf):
    _mode = redis_conf['mode'].lower()
    _password = redis_conf['password']
    _servers = []
    for _item in redis_conf['servers']:
        _servers.append((_item['host'], _item['port']))

    if _mode == 'standalone':
        return RedisHelper(_servers[0], _password, 10)
    elif _mode == 'sentinel':
        return RedisHelper(_servers, _password, 10, master_name=redis_conf['master_name'])
    else:
        raise Exception(f'Redis mode not supported: {_mode}')

def getRunFile(path):
    tmpList=glob.glob(path+"/RUN*")
    data=[]
    for item in tmpList:
        data.append(int(item[-7:]))
    return data

if __name__=="__main__":
    confFile = "conf.json"
    with open(confFile,"r") as json_file:
        conf=json.load(json_file)

    rds=getRedisHelper(conf["redis"]) 
    path="/mpi/expRecInfo"

    print("hello")

    while True:
        expInfo = rds.read(path)
        if expInfo is None:
            print("This is None!")
            time.sleep(10)
        else:
            expInfo=json.loads(bytes.decode(expInfo))
            startT0=int((expInfo["startPulseId"]))
            endT0=int((expInfo["endPulseId"]))
            run=expInfo["runNo"]
            runNo=run[3:]
            runNo=int(runNo)
            existRun = getRunFile("./expRun")
            if runNo in existRun:
                pass
            else:
                if endT0-startT0>25:
                    path="./expRun/"
                    with open(path+run,"w") as f0:
                        f0.write("%d %d %d"%(runNo,startT0,endT0))
                        f0.write("\n")
                    f0.close()
                    judgeT0=startT0
                    judgeRun=runNo
                    time.sleep(20)
            time.sleep(20)
