#from mantid.simpleapi import *
import threading
import numpy as np
import time

class bankIO(threading.Thread):
    def __init__(self,neonRedis, refreshtime):
        super(bankIO, self).__init__()
        
        self.refreshtime=refreshtime
        self.neonRedis=neonRedis
        self.sendPath="/mpi/mantid/"
        self.dic={
                "bank5":[10502,10503,10504,10505],
                "bank6":[10602,10603],
                "bank7":[10701,10702,10703,10704],
                "bank8":[10801,10802,10803,10804],
                "bank9":[10902,10903],
                "bank10":[11002,11003,11004,11005],
                "g1":[10502,10503,10504,10505,11002,11003,11004,11005],
                "g2":[10602,10603,10902,10903],
                "g3":[10701,10702,10703,10704,10801,10802,10803,10804]
                }
        self.bankList=[5,6,7,8,9,10]

    def getXdata(self,constA):
        path="/mpi/mantid/module10502/d"
        x_d = self.neonRedis.readNumpyArray(path)
        x_tof=x_d*constA
        return x_d,x_tof


    def mergeData(self,bankname,length):
        mList=self.dic[bankname]
        v=np.zeros(length)
        for num in mList:
            name="module"+str(num)
            path="/mpi/mantid/"+name+"/d_counts"
            v+=self.neonRedis.readNumpyArray(path)
        return v    
    
    def setData(self,bankname,constA):
        x_d,x_tof=self.getXdata(constA)
        
        prepath="/mpi/mantid/group"+str(bankname[4:]).zfill(2)+"/raw"
        self.neonRedis.writeNumpyArray(prepath+"/d",x_d)
        self.neonRedis.writeNumpyArray(prepath+"/tof",x_tof)
        
        value = self.mergeData(bankname,len(x_d))
        self.neonRedis.writeNumpyArray(prepath+"/d_counts",value)
        self.neonRedis.writeNumpyArray(prepath+"/tof_counts",value)
        
    def saveData(self,name,constA):
        x_d,x_tof=self.getXdata(constA)
        value = self.mergeData(name,len(x_d))
        d_arr=np.array((x_d,value)).T
        tof_arr=np.array((x_tof,value)).T
        fname=name+"_d.txt"
        np.savetxt(fname,d_arr,fmt="%.4f", delimiter=" ")
        fname=name+"_tof.txt"
        np.savetxt(fname,tof_arr,fmt="%.2f", delimiter=" ")

    def process(self):
        self.setData("bank5",10290.0)
        self.setData("bank6",13747.0)
        self.setData("bank7",15489.0)
        self.setData("bank8",15489.0)
        self.setData("bank9",13747.0)
        self.setData("bank10",10290.0)
        self.saveData("g1",10290.0)
        self.saveData("g2",13747.0)
        self.saveData("g3",15489.0)

    def run(self):
        while True:
            #try:
            self.process()
            time.sleep(20)
            #except:
            #    time.sleep(10)
