import time, datetime
from IO.RedisHelper import RedisHelper
import baseComp
from IO.Kafka import getDetectorData, getGlobalData, KafkaGrabber
import re
import os
import numpy as np
import subprocess

def getRuntoMerge():
    recList=[]
    complete=os.listdir("./complete")
    db=os.listdir("./runlog")
    for item in db:
        if item[:3]=="RUN" and item not in complete:
            recList.append(item)
    return recList

def createDir(path):
    if os.path.exists(path):
        pass
    else:
        os.mkdir(path)

def getMonitorPixelId(monitor):
    nx=1
    ny=1
    num=monitor[-2:]
    idstart=int('201'+num+"0001")
    pixel_id=np.arange(idstart,idstart+int(nx*ny))
    pixel_id=pixel_id.reshape((nx,ny))
    return pixel_id

def getRedisHelper(redis_conf):
    _mode = redis_conf['mode'].lower()
    _password = redis_conf['password']
    _servers = []
    for _item in redis_conf['servers']:
        _servers.append((_item['host'], _item['port']))
    if _mode == 'standalone':
        return RedisHelper(_servers[0], _password, 10)
    elif _mode == 'sentinel':
        return RedisHelper(_servers, _password, 10, master_name=redis_conf['master_name'])
    else:
        raise Exception(f'Redis mode not supported: {_mode}')


def getName(conf,typename):
    _topic = conf['topic']
    if typename=="monitor":
        num=_topic.find("Monitor")
        _p="monitor"+_topic[num+7:num+9]
    else:
        num=_topic.find("Bank")
        _p="module1"+_topic[num+4:num+6]
        num=_topic.find("Module")
        _p+=_topic[num+6:num+8]
    return _p

def onlineDetector(conf,mname,prepath,tofs,chunksize,t1,t2):
    print("start online: ",mname)
    offset = getOffset(conf)-t1
    #offset=3945633

    print("start offset: ",mname,offset)
    task = KafkaGrabber(conf, offset)
    consumer=task.getKafkaConsumer()
    nxsfile=prepath+"/"+mname+".nxs"
    run = baseComp.nxsWrite()
    if mname[:6]=="module":
        run.recSingleModule(prepath,mname,tofs, chunksize, consumer,t1,t2)
    else:
        print("start rec monitor")
        run.recSingleMonitor(prepath,mname,tofs,consumer,t1,t2)
    #_cmd = 'scp ./complete/complete_'+mname+" "+prepath
    #subprocess.check_call(_cmd, shell=True)
    print("finish online ",mname)


def manualDetector(conf,mname,prepath,tofs,chunksize,t1,t2):
    task = KafkaGrabber(conf)
    consumer=task.getKafkaConsumerFromBegin()
    nxsfile=prepath+"/"+mname+".nxs"
    run = baseComp.nxsWrite()
    if mname[:6]=="module":
        run.recSingleModule(prepath,mname,tofs, chunksize, consumer,t1,t2)
    else:
        run.recSingleMonitor(prepath,mname,tofs,consumer,t1,t2)
    #_cmd = 'scp ./complete/complete_'+mname+" "+prepath
    #subprocess.check_call(_cmd, shell=True)
    print("finish online ",mname)

def manualHistDetector(conf,mname,prepath,tofs,t1,t2):
    task = KafkaGrabber(conf)
    consumer=task.getKafkaConsumerFromBegin()
    nxsfile=prepath+"/"+mname+".nxs"
    run = baseComp.nxsWrite()
    if mname[:6]=="module":
        run.recHistSingleModule(prepath,mname,tofs,consumer,t1,t2)
    else:
        run.recSingleMonitor(prepath,mname,tofs,consumer,t1,t2)
    #_cmd = 'scp ./complete/complete_'+mname+" "+prepath
    #subprocess.check_call(_cmd, shell=True)
    print("finish online ",mname)




pulse_conf={
            "auto_offset_reset": "earliest",
                "bootstrap_servers": [
                    "10.1.29.120:9092"
                ],
                "comment": "Proton Charge",
                "consumer_timeout_ms": "inf",
                "data_type": "meta",
                "enable_auto_commit": True,
                "enabled": True,
                "group_id": "mpi_dr",
                "topic": "PulseBeam"
        }


class timeConvert():
    def __init__(self):
        self.local_format="%Y-%m-%dT%H:%M:%S"

    def getCurrPulseIdSecond(self):
        confFile = "conf.json"
        with open(confFile,"r") as json_file:
            conf=json.load(json_file)
        item=conf["modules"]["global_modules"]:
        task = KafkaGrabber(item)
        consumer=task.getKafkaConsumer()
        for msg in consumer:
            pulseId,_,_,timeSecond = getGlobalData(msg)
            break
        consumer.close()
        return pulseId,timeSecond

    def utc_stamp_to_local(self,seconds):
        utc_time=datetime.datetime.utcfromtimestamp(seconds)
        local=utc_time+datetime.timedelta(hours=8)
        local=local.strftime(self.local_format)
        return local

    def local_to_utc_stamp(self,local):
        dt=datetime.datetime.strptime(local, self.local_format)
        dt=dt+datetime.timedelta(hours=-8)
        stamp=time.mktime(dt.timetuple())
        return stamp
    
    def local2PulseId(self,local):
        ts = self.local_to_utc_stamp(local)
        curPulseId,curTime=self.getCurrPulseIdSecond()
        offsetTS=curTime-ts
        if offsetTS<0:
            print("error in kafka data!")
        else:
            offsetPulseId=offsetTS*25
            pulseId=curPulseId-offsetPulseId
        return pulseId

    def pulseId2Local(self, pulseId):
        curPulseId,curTime=self.getCurrPulseIdSecond()
        offsetPulseId=curPulseId-pulseId
        if offsetPulseId<0:
            print("error in kafka data!")
        else:
            offsetTS=offsetPulseId/25.0
            ts=curTime-offsetTS
            local = self.utc_stamp_to_local(ts)
        return local
