#!/usr/bin/env python3

from iMACS.Config import KafkaConfig, HistConfig, RedisConfig, RedisRWConfig, ConfigGenerator,ConfigHelper
from iMACS.Tasks import ManagedKafkaTask
import json
import multiprocessing as mp

gen = ConfigGenerator()
#redis
rdisConfObj=RedisConfig()
rdisConfObj.set(class_name='ManagedRedis')
rdisConfObj.set(password='sanlie_123') #set a single parameter
rdisConfObj.set(master_name='mpi_redis_master', db=0) #or multiple parameters
servers= [("10.1.37.241","26379"),("10.1.37.246","26379"),("10.1.37.247","26379")]

rdisConfObj.set(servers=servers, socket_timeout=100)
gen.addConfig(rdisConfObj)

#print(rdisConfObj.getJson())

################################################################
bank=10
module=5
pixelNum=800

#histogram redis
rRW = RedisRWConfig()
rRW.set(class_name='None a class')
rRW.set(redis_info=rdisConfObj.getDict())
rRW.set(update_interval_sec=1)

moduleID=int(1e4+bank*1e2+module)
updateTarget=[]
updateTarget.append({'redisPath': f'/MPI/workspace/detector/module{moduleID}/value', \
                     'data':'self.hist', \
                     'mode': 'wnp' })

updateTarget.append({'redisPath': f'/mpi/imacs/detector_counts/module{moduleID}', \
                     'data':'self.hist.sum()', \
                     'mode': 'w' })
rRW.set(target=updateTarget)


minPixelID= 1e8 + bank*1e6 + module * 1e4

#histogram
histCfgObj = HistConfig()
histCfgObj.set(class_name='ManagedHistRedis')
histCfgObj.set(xBinNum=2500)
histCfgObj.set(xmin=-0.5)
histCfgObj.set(xmax=40000-0.5)

histCfgObj.set(yBinNum=pixelNum)
histCfgObj.set(ymin=minPixelID+0.5)
histCfgObj.set(ymax=minPixelID+0.5+pixelNum)
histCfgObj.set(redis_readwrite=rRW.getDict())

#kafka
kfkCfgObj = KafkaConfig()
kfkCfgObj.set(class_name='ManagedKafkaTask')
kfkCfgObj.set(bootstrap_servers=[ \
                    "10.1.37.205:9092",\
                    "10.1.37.206:9092",\
                    "10.1.37.207:9092",\
                    "10.1.37.208:9092"])
kfkCfgObj.set(data_type='event')
kfkCfgObj.set(topic='BL16-Detector-tmp5-Bank10-Module05-EventData')
kfkCfgObj.set(group_id = 'durong_test', seek_type='beginning' )
kfkCfgObj.set(histogram=histCfgObj.getDict())

#print(kfkCfgObj.getJson())

gen.addConfig(kfkCfgObj)


fname='test_config.json'
gen.saveAs(fname)

count=mp.Value('d',0)
countlock = mp.Lock()

ctrl=mp.Value('i',1)
ctrlLock = mp.Lock()

sharedNumHit=(count,countlock)
control=(ctrl, ctrlLock)


chlp = ConfigHelper(fname)
cfgItems= chlp.getValue('Managed')
task = eval(cfgItems[0].get('class_name'))(cfgItems[0], sharedControl = control, sharedNumHit=sharedNumHit )
task.start()
