
import collections
import numpy as np

class CircularBuffer:
    def __init__(self, cirBufSize, rejectionRate):
        self.cirBuf = collections.deque(maxlen=cirBufSize)
        for i in range(cirBufSize):
            self.cirBuf.append(0.)
        self.cirBufCnt = 0
        self.rejr = rejectionRate

    def append(self, item):
        self.cirBufCnt += 1
        if self.cirBufCnt ==self.rejr:
            self.cirBuf.append(item)
            self.cirBufCnt = 0


    def get(self):
        return np.array(self.cirBuf)
