from xml.etree import ElementTree as ET
import xml.dom as DOM
import sys
import numpy as np
import math


def readDetectorInfoFile(a,bankNum):
    #print(bankNum)
    for i in range(len(a)):
        idNo=int(a[i][0])
        if idNo==bankNum:
            #print(idNo)
            _p1=[float(a[i][1])/1000.,float(a[i][2])/1000.,float(a[i][3])/1000.]
            _p2=[float(a[i][4])/1000.,float(a[i][5])/1000.,float(a[i][6])/1000.]
            _p3=[float(a[i][7])/1000.,float(a[i][8])/1000.,float(a[i][9])/1000.]
            _p4=[float(a[i][10])/1000.,float(a[i][11])/1000.,float(a[i][12])/1000.]
            _modules=[_p1,_p2,_p3,_p4]
    return _modules

def calAngle(v1,v2):
    v1_len_sq = v1[0]**2+v1[1]**2+v1[2]**2
    v2_len_sq = v2[0]**2+v2[1]**2+v2[2]**2
    a = v1[0]*v2[0]+v1[1]*v2[1]+v1[2]*v2[2]
    b = math.sqrt(v1_len_sq*v2_len_sq)
    angle = math.acos(a/b)*180/math.pi
    return angle

def getYrotate(points, tubeLen):
    x = points[1][0]-points[0][0]
    y = points[1][1]-points[0][1]
    z = points[1][2]-points[0][2]
    v_ab = [x, y, z]
    v_z = [0,0,tubeLen]
    v_x = [tubeLen,0,0]
    #print (v_ab)
    z_angle = calAngle(v_ab,v_z)
    #print (z_angle)
    x_angle = calAngle(v_ab, v_x)
    if z_angle<90:
        return (180.0-x_angle)
    elif z_angle > 90:
        return -(180-x_angle)
    else:
        if points[0][2]>0:
            return 180
        else:
            return 0

def getZrotate(points,tubeLen):
    x = points[3][0]-points[0][0]
    y = points[3][1]-points[0][1]
    z = points[3][2]-points[0][2]
    v_ad = [x, y, z]
    #print (v_ad)
    v_y = [0,tubeLen,0]
    v_x = [tubeLen, 0,0]
    x_angle = calAngle(v_ad, v_x)
    y_angle = calAngle(v_ad, v_y)
    if x_angle > 90:
        return y_angle
    elif x_angle <90:
        return -y_angle
    else:
        return 0

class writeIDF():
    def __init__(self, instName, L1, moduleList, filename):
        self.L1=-L1
        self.instName=instName
        self.moduleList=moduleList
        #self.tubeLen=tubeLen
        #self.tubeNum=8
        #self.xsize=0.005
        #self.ysize=0.0264
        #self.xpixels = int(tubeLen/self.xsize)
        #self.ypixels = 8
        #self.bankName='module'+str(bankNum)
        self.info=np.loadtxt(filename,delimiter=" ", skiprows=0, unpack=False)
        #print(self.info)
    def writeRoot(self):
        self.root=ET.Element('instrument',{'xmlns':'http://www.mantidproject.org/IDF/1.0','xmlns:xsi':'http://www.w3.org/2001/XMLSchema-instance','xsi:schemaLocation':'http://www.mantidproject.org/IDF/1.0 Schema/IDFSchema.xsd','name':self.instName,'valid-from':'2017-01-29 00:00:00','valid-to':'2050-01-29 00:00:00','last-modified':'2017-06-29 00:00:00'})
        group=ET.SubElement(self.root,'defaults')
        ET.SubElement(group,'length',{'unit':'meter'})
        ET.SubElement(group,'angle',{'unit':'degree'})
        g1=ET.SubElement(group,'reference-frame')
        ET.SubElement(g1,'along-beam',{'axis':'z'})
        ET.SubElement(g1,'pointing-up',{'axis':'y'})
        ET.SubElement(g1,'handedness',{'val':'right'})

    def writeOtherComp(self):
        #moderator,sample position
        group=ET.SubElement(self.root,'component',{'type':'moderator'})
        ET.SubElement(group,'location',{'z':str(self.L1)})
        group=ET.SubElement(self.root,'type',{'is':'Source','name':'moderator'})
        group=ET.SubElement(self.root,'component',{'type':'sample-position'})
        ET.SubElement(group,'location',{'z':'0.0','x':'0.0','y':'0.0'})
        group=ET.SubElement(self.root,'type',{'is':'SamplePos','name':'sample-position'})


        #get module info
    def writeModules(self,bankname,xpids,tubeLen):
        
        group=ET.SubElement(self.root,'component',{'type':bankname})
        ET.SubElement(group,'location')

        group=ET.SubElement(self.root,'type',{'name':bankname})
        for num in self.moduleList:
            moduleInfo = readDetectorInfoFile(self.info, num)       
            moduleName = "module"+str(num)
            print ("**********",moduleName,"************")
            
            idstart = str(num)+"0001"
            point = moduleInfo
            #print("t:",moduleInfo,point)
            x=point[0][0]
            y=point[0][1]
            z=point[0][2]
            g1=ET.SubElement(group,'component',{'type':'panel','idfillbyfirst':'x','idstart':idstart,'idstepbyrow':str(xpids)})
            g11=ET.SubElement(g1,'location',{'name':moduleName,'x':str(x),'y':str(y),'z':str(z)})
            yRotate = getYrotate(point,tubeLen)
            g12 = ET.SubElement(g11,'rot',{'val':str(yRotate),'axis-x':'0.0','axis-y':'1.0','axis-z':'0.0'})
            zRotate = getZrotate(point,tubeLen)
            if zRotate!=0:
                ET.SubElement(g12,'rot',{'val':str(zRotate),'axis-x':'1.0','axis-y':'0.0','axis-z':'0.0'})

    def writePanel(self, xpids,ypids,xsize,ysize):
        panelDict={'is':'rectangular_detector','name':'panel','type':'pixel','xpixels':str(xpids),'xstep':str(-xsize),'xstart':'0','ypixels':str(ypids),'ystep':str(ysize),'ystart':'0'}
        group=ET.SubElement(self.root,'type',panelDict)
        ET.SubElement(group,'properties')

    def writePixel(self,xsize,ysize):
        group=ET.SubElement(self.root,'type',{'is':'detector','name':'pixel'})
        g1=ET.SubElement(group,'cuboid',{'id':'pixel-shape'})
        ET.SubElement(g1,'left-front-bottom-point',{'x':str(-xsize/2.0),'y':str(-ysize/2.0),'z':'0.0'})
        ET.SubElement(g1,'left-front-top-point',{'x':str(-xsize/2.0),'y':str(ysize/2.0),'z':'0.0'})
        ET.SubElement(g1,'left-back-bottom-point',{'x':str(-xsize/2.0),'y':str(ysize/2.0),'z':'-0.0001'})
        ET.SubElement(g1,'right-front-bottom-point',{'x':str(xsize/2.0),'y':str(ysize/2.0),'z':'0.0'})
        ET.SubElement(group,'algebra',{'val':'pixel-shape'})

    def transform(self,name):
        tree=ET.ElementTree(self.root)
        #ET.dump(tree)
        #tree.write(bankName+'.xml',encoding='utf-8',xml_declaration='1.0',method="xml")
        tree.write('tmp.xml',encoding='utf-8',xml_declaration=True,method="xml")
        import xml.dom.minidom
        xml = xml.dom.minidom.parse("tmp.xml")
        f=open("MPI_Definition_"+name+".xml",'wb')
        f.write(xml.toprettyxml(indent="\t", newl="\n", encoding='utf-8'))
        f.close()

