import writeXML
import sys

fname="mpi_detector_info.txt"
#unit:meter
l1=30.0

#moduleList=[11005,11004,11003,11002,10505,10504,10503,10502,10704,10703,10702,10701,10903,10902,10603,10602,10404,10403,10304,10303,10804,10803,10802,10801]

dic={}
numList=[1,6,6,7,7,4,4,4,4,7,7,6,6]
for i in range(13):
    dic["bank"+str(i+1)]=[]
    num=numList[i]
    for j in range(num):
        data=10000+(i+1)*100+j+1
        dic["bank"+str(i+1)].append(data)

#print(dic)

banknum=5
bankname="bank"+str(banknum)
moduleList=dic[bankname]
tubeLen=0.5
if banknum==7 or banknum==8:
    tubeLen=0.3
xsize=0.005
ysize=0.0264
xpixels = int(tubeLen/xsize)
ypixels = 8

run=writeXML.writeIDF("MPI",l1,moduleList,fname)
run.writeRoot()
run.writeOtherComp()
run.writeModules(bankname,xpixels,tubeLen)
run.writePanel(xpixels,ypixels,xsize,ysize)
run.writePixel(xsize,ysize)
run.transform(bankname)
