import h5py
import time
import baseComp
import numpy as np

moduleList=['module10303','module10304','module10403']
#moduleList=['module10303']

be=time.time()
prepath="/home/dur/git/iMACS/recnxs"
nxsFile=prepath+"/merge.nxs"
f_nxs=h5py.File(nxsFile,"w")
nf=baseComp.nxsWrite(f_nxs)
nf.createBasicFramework()
nf.writeFileAttrs(nxsFile)
nf.createModuleGroup(moduleList)

for name in moduleList:
    print(name)
    f0=h5py.File(prepath+"/"+name+".nxs","r")
    tof = f0["/csns/instrument/"+name+"/event_time_of_flight"]
    pid = f0["/csns/instrument/"+name+"/event_pixel_id"]
    pulse = f0["/csns/instrument/"+name+"/event_pulse_time"]
    f_nxs["/csns/instrument/"+name].create_dataset("event_time_of_flight",tof.shape,dtype=tof.dtype,compression='gzip',data=tof)
    f_nxs["/csns/instrument/"+name].create_dataset("event_pulse_time",pulse.shape,dtype=pulse.dtype,compression='gzip',data=pulse)
    f_nxs["/csns/instrument/"+name].create_dataset("event_pixel_id",pid.shape,dtype=pid.dtype,compression='gzip',data=pid)
    
    f0.close()

f_nxs.close()
print(time.time()-be," seconds!")
