from kafka import KafkaConsumer, TopicPartition

import datetime
import sys, time
import Data.Global.MetaData
import Data.Detector.EventData


import kafkaIO
import reckafka
import sys

confname="conf_kafka.json"
topic="PuselBeam"
kf = kafkaIO.baseOP(confname,topic)


local_format="%Y-%m-%dT%H:%M:%S"

def utc_stamp_to_local(seconds):
    utc_time=datetime.datetime.utcfromtimestamp(seconds)
    #print(utc_time)
    local=utc_time+datetime.timedelta(hours=8)
    local=local.strftime(local_format)
    return local

def local_to_utc_stamp(local):
    dt=datetime.datetime.strptime(local, local_format)
    dt=dt+datetime.timedelta(hours=-8)
    stamp=time.mktime(dt.timetuple())
    return stamp

def getPulseConsumer(conf):
    consumer=KafkaConsumer(group_id=conf['group_id'], bootstrap_servers=conf['bootstrap_servers'], auto_offset_reset=conf['auto_offset_reset'], enable_auto_commit=True, consumer_timeout_ms=conf['consumer_timeout_ms'])
    partition = TopicPartition(conf['topic'], 0)
    consumer.assign([partition])
    #consumer.seek_to_beginning()
    consumer.seek_to_end()
    offset=consumer.position(partition)
    consumer.seek(partition, offset-25*60*60*24)
    return consumer,offset

def getEvtConsumer(conf,hours):
    consumer=KafkaConsumer(group_id=conf['group_id'], bootstrap_servers=conf['bootstrap_servers'], auto_offset_reset=conf['auto_offset_reset'], enable_auto_commit=True, consumer_timeout_ms=conf['consumer_timeout_ms'])
    partition = TopicPartition(conf['topic'], 0)
    consumer.assign([partition])
    consumer.seek_to_end()
    offset=consumer.position(partition)
    consumer.seek(partition, offset-25*60*60*hours)
    return consumer,offset


def getConsumer(conf,hours):
    consumer=KafkaConsumer(group_id=conf['group_id'], bootstrap_servers=conf['bootstrap_servers'], auto_offset_reset=conf['auto_offset_reset'], enable_auto_commit=True, consumer_timeout_ms=conf['consumer_timeout_ms'])
    partition = TopicPartition(conf['topic'], 0)
    consumer.assign([partition])
    consumer.seek_to_end()
    offset=consumer.position(partition)
    consumer.seek(partition, offset-25*60*60*hours)
    return consumer,offset


#bootstrap_servers=['10.1.29.120:9092']
#group_id='mpi_pulse'
#topic="PulseBeam"
pulseConf={"bootstrap_servers":['10.1.29.120:9092'],"group_id":"mpi_pulse","topic":"PulseBeam","auto_offset_reset":"earliest","consumer_timeout_ms":5000}



'''
t1=204769306
t2=204769356
xmlPath="/home/dur/git/iMACS/recnxs/idf"
moduleList=[["module10304"],["module10303"],["module10403"],["module10404"]]
for mList in moduleList:
    num=mList[0][7:9]
    bankName="Bank"+num
    num=mList[0][9:11]
    mName="Module"+num
    #print(bankName,mName)
    #sys.exit()
    topic='BL16-Detector-'+bankName+'-'+mName+'-EventData'
    evtConf={"bootstrap_servers":['10.1.36.82:9092'],"group_id":"mpi_evt","topic":topic,"auto_offset_reset":"earliest","consumer_timeout_ms":5000}
    consumer,off=getConsumer(evtConf,48)
    fName=mList[0]+".nxs"
    run=reckafka.dataSvc(consumer,xmlPath)
    run.recEvtNxs(fName,mList,t1,t2)
#startTime="2021-01-13T12:00:00"
#endTime="2021-01-13T12:30:00"
#a1=local_to_utc_stamp(startTime)
#a2=local_to_utc_stamp(endTime)
'''

pconsumer,offset=getConsumer(pulseConf,24)
print("================pulseBeam topic 24hours from now======================")
print("offset for now: ",offset)
for msg in pconsumer:
    _data = Data.Global.MetaData.MetaData.GetRootAsMetaData(msg.value, 0)
    _ts = _data.TimeSecondAsNumpy()[0]
    p=_data.PulseId()
    lt=utc_stamp_to_local(_ts)
    print("==============use class====================")
    print(kf.pulseId2Local(p))
    print(kf.local2PulseId(lt))
    print("first pulseId:",p," stamp: ",_ts, " local: ",lt)
    break
pconsumer.close()

#sys.exit()
#t1,t2=getT0(startTime,endTime,pulseConf)
#print(t1,t2)

#5min
#get evt

