#!/usr/bin/env python3
import baseOP
import reckafka
import datetime
import json
import os

if __name__ == "__main__":
    print("begin to reconstruction...")
    with open("conf_modules.json","r") as json_file:
        dic = json.load(json_file)
    moduleList=dic["moduleList"]
    folder=str(datetime.datetime.now()) 
    dataPath="/home/dur/"+folder
    os.mkdir(dataPath)
    confFile = "./jsonFile/conf_kafka_evt.json"

    bp=baseOP.timeConvert()
    startTime="2020-12-20T00:00:00"
    endTime="2020-12-27T00:00:00"
    startT0=bp.local2PulseId(startTime)
    endT0=bp.local2PulseId(endTime)
    #startT0=204769306
    #endT0=204818306
    xmlPath="/home/dur/git/iMACS/recnxs/writeIDF/idf"
    for num in moduleList:
        moduleName="Module"+str(num)[-2:]
        bankName="Bank"+str(num)[1:3]
        topic = 'BL16-Detector-'+bankName+'-'+moduleName+'-EventData'
        kf = baseOP.kafkaIO(confFile,topic)
        consumer = kf.createKafkaConsumer(24*10)
        nxsfile=dataPath+"/module"+str(num)+".nxs"
        run = reckafka.dataSvc(consumer, xmlPath)
        run.recEvtNxs(nxsfile,"module"+str(num),startT0,endT0)

