import flatbuffers
from kafka import KafkaConsumer, TopicPartition
import json
import time, datetime

class timeConvert():
    def __init__(self):
        self.local_format="%Y-%m-%dT%H:%M:%S"
        self.startSecond=1609430400.0
        self.startLocal="2021-01-01T00:00:00"
        self.startPulseId=214246007

    def utc_stamp_to_local(self,seconds):
        utc_time=datetime.datetime.utcfromtimestamp(seconds)
        local=utc_time+datetime.timedelta(hours=8)
        local=local.strftime(self.local_format)
        return local

    def local_to_utc_stamp(self,local):
        dt=datetime.datetime.strptime(local, self.local_format)
        dt=dt+datetime.timedelta(hours=-8)
        stamp=time.mktime(dt.timetuple())
        return stamp
    
    def local2PulseId(self,local):
        ts = self.local_to_utc_stamp(local)
        offset = ts-self.startSecond
        pId = int(offset*25+self.startPulseId)
        return pId

    def pulseId2Local(self, pId):
        local = self.utc_stamp_to_local(self.startSecond+(pId-self.startPulseId)/25)
        return local

class kafkaIO():
    def __init__(self,confName,topic):
        with open(confName,"r") as json_file:
            self.conf=json.load(json_file)
        self.topic=topic

    def createKafkaConsumer(self,hours):
        consumer = KafkaConsumer(group_id=self.conf['group_id'],
                bootstrap_servers=self.conf['bootstrap_servers'],
                auto_offset_reset=self.conf['auto_offset_reset'],
                enable_auto_commit=self.conf['enable_auto_commit'],
                consumer_timeout_ms=self.conf['consumer_timeout_ms'])
        #consumer.subscribe(topics=[self.topic])
        partition = TopicPartition(self.topic, 0)
        consumer.assign([partition])
        #consumer.seek_to_beginning()
        consumer.seek_to_end()
        offset=consumer.position(partition)
        consumer.seek(partition, offset-25*60*60*24)
        return consumer



   

