import h5py
import numpy as np
import os
import time
import datetime
from xml.etree import ElementTree as ET
import re

pubName = ["beamline","description","measurement_type","proposal_id","proton_charge","run_no","version","wavelength","start_time_tai","start_time_utc","end_time_tai","end_time_utc","instrument_bank_definition","instrument_bank_file","instrument_name"]

def writeGroup(parent,name,ntype):
    grp = parent.create_group(name)
    grp.attrs["NX_class"] = ntype
    return grp

def writeSingleData(grp, dic):
    for key in dic: 
        grp.create_dataset(key, data = dic[key])

def writeArrData(grp,name, arr,datatype,compression):
    size=arr.shape
    grp.create_dataset(name,size,dtype=datatype, compression=compression, data=arr)


class nxsWrite():
    def __init__(self,nxsfile):
        self.nxs=nxsfile

    def createBasicFramework(self):
        root = writeGroup(self.nxs,"csns","NXentry")
        grp1 = writeGroup(root,"instrument","NXinstrument")
        grp2 = writeGroup(root,"histogram_data","NXcollection")
        grp3 = writeGroup(root,"event_data","NXcollection")
        grp4 = writeGroup(root,"logs","NXcollection")
        grp5 = writeGroup(root,"process","NXprocess")
        grp6 = writeGroup(root,"user","NXuser")

    def writeFileAttrs(self,fName):
        self.nxs.attrs["default"]="entry"
        self.nxs.attrs["file_name"]=fName
        timestamp = str(datetime.datetime.now())
        self.nxs.attrs["file_time"]=timestamp
        self.nxs.attrs["NeXus_Version"]="4.3.0"
        self.nxs.attrs["HDF5_Version"]="1.8.12"

    def writePublicData(self,dic):
         writeSingleData(self.nxs["/csns"], dic)


    def createModule(self,module):
        son1 = writeGroup(self.nxs["/csns/instrument"],module,"NXdetector")
        son2 = writeGroup(self.nxs["/csns/histogram_data"],module,"NXdata")
        son3 = writeGroup(self.nxs["/csns/event_data"],module,"NXdata")

    def createEvent(self,module,chunkSize,compression):
        ds_tof=self.nxs["/csns/instrument/"+module].create_dataset("event_time_of_flight", (chunkSize, ), maxshape=(None, ), dtype='float', compression=compression, chunks=(chunkSize, ))
        ds_pid=self.nxs["/csns/instrument/"+module].create_dataset("event_pixel_id", (chunkSize, ), maxshape=(None, ), dtype='int64', compression=compression, chunks=(chunkSize, ))
        ds_pulse=self.nxs["/csns/instrument/"+module].create_dataset("event_pulse_time", (chunkSize, ), maxshape=(None, ), dtype='int64', compression=compression, chunks=(chunkSize, ))
    
        return ds_pid,ds_tof,ds_pulse
    
    def writeEventLink(self,module):
        self.nxs["/csns/event_data/"+module]["event_time_of_flight"]=h5py.SoftLink("/csns/instrument/"+module+"/event_time_of_flight")
        self.nxs["/csns/event_data/"+module]["event_pixel_id"]=h5py.SoftLink("/csns/instrument/"+module+"/event_pixel_id")
        self.nxs["/csns/event_data/"+module]["event_pulse_time"]=h5py.SoftLink("/csns/instrument/"+module+"/event_pulse_time")
        
        

    def writeHistogram(self,module,compression,histData):
        grp=self.nxs["/csns/instrument/"+module]
        writeArrData(grp,"histogram_data", histData,'int32',compression)

    def writeHistogramLink(self,module):
        self.nxs["/csns/histogram_data/"+module]["histogram_data"]=h5py.SoftLink("/csns/instrument/"+module+"/histogram_data")
        self.nxs["/csns/histogram_data/"+module]["time_of_flight"]=h5py.SoftLink("/csns/instrument/"+module+"/time_of_flight")
        
    
    def writePid(self,module,pixel,compression):
        grp=self.nxs["/csns/instrument/"+module]
        writeArrData(grp,"pixel_id", pixel,'int32',compression)
    
    def writeTof(self,module, tof, compression):
        grp=self.nxs["/csns/instrument/"+module]
        writeArrData(grp,"time_of_flight", tof,'int32',compression)

#histgram  uint32_t

def getXmlTag(parseName):
    name=''
    nsmatch=re.match('\{.*\}', parseName.getroot().tag)
    if nsmatch:
        name=nsmatch.group(0)
    return name

class getMetaData():
    
    def getPixelId(self,module,path):
        root = ET.parse(path+'/MPI_Definition_'+module+'.xml')
        ns=getXmlTag(root)        
        for item in root.findall(ns+'type'):
            if item.attrib['name']== module:
                tmp = item.find(ns+'component')
                idstart=int(tmp.attrib['idstart'])
            if item.attrib['name']== 'panel':
                x=int(item.attrib['xpixels'])
                y=int(item.attrib['ypixels'])
        pidNums=x*y
        data=[]
        for i in range(pidNums):
            data.append(idstart+i)
        data=np.array(data)
        data=data.reshape(x,y)
        return data

    def getTof(self,tofStart,tofEnd,tofStep):
        arr=[]
        bins=int((tofEnd-tofStart)/tofStep)+1
        for i in range(bins):
            arr.append(tofStart+i*tofStep)
        arr=np.array(arr)
        return arr

    def getHistData(self,myredis,path):
        data = myredis,readNumpyArray(path)
        data = data.T
        return data


    def getExpStatus(self,myredis,path):
        pass
    
    def getPublicInfo(self,myredis,path):
        info = myredis.read(path)
        dic={}
        #dic

'''
def writeInst_Module(f_nxs,moduleName,pidData,tofData,pulseData):
    grp = f_nxs.create_group("/csns/instrument")
    grp.attrs["NX_class"] = "NXinstrument"
    grp2= grp.create_group(moduleName)
    grp2.attrs["NX_class"] = "NXdetector"
    ds=grp2.create_dataset("event_pixel_id",dtype="int64",compression="gzip", data=pidData)
    ds=grp2.create_dataset("event_pulse_time",dtype="int64",compression="gzip", data=pulseData)
    ds=grp2.create_dataset("event_time_of_fligth",dtype="int64",compression="gzip", data=tofData)

def writeInst_moderator(grp_inst, moderatorDict):
    grp = grp_inst.create_group("moderator")
    grp.attrs["NX_class"] = "NXmoderator"
    grp.create_dataset("type", data = moderatorTpye)
    ds = grp.create_dataset("distance", data = moderatorDict["distance"])
    ds.attrs["units"] = "m"
    ds = grp.create_dataset("temperature", data = moderatorDict["temperature"])
    ds.attrs["units"] = "K"
'''


