import multiprocessing as mp
from multiprocessing import Process
import threading
from time import sleep

class TaskManager:
    def __init__(self, taskList={}, printProc=False):
        self.active = True
        self.stopped = False
        self.printProc = printProc
        self.queue = mp.Queue()

        self.processes = {}
        for taskName, task in taskList.items():
            self.addActiveProc(taskName, task)

        self.houseKeeper = threading.Thread(target=self.houseKeeping)
        self.houseKeeper.start()

    def __del__(self):
        self.active=False
        self.houseKeeper.join()

    def addActiveProc(self, taskName, task):
        proc = Process(target=task) #to be expended in a thread
        proc.daemon = True #fixme: daemon?
        self.processes[taskName] = (proc, task)
        proc.start()

    def stopProc(self):
        self.active=False
        while not self.stopped:
            sleep(0.1)

        for taskName, v in self.processes.items():
            proc = v[0]
            task = v[1]
            proc.terminate()
            proc.join()

    def houseKeeping(self):
        #monitor processes constantly
        while len(self.processes) > 0 and self.active:
            self.stopped=False
            for taskName, v in self.processes.items():
                proc = v[0]
                task = v[1]
                if not proc.is_alive():
                    print(proc, task, "is not alive")
                    if proc.exitcode is None:
                        print(p, a, "never exists, so has not return an exit code")
                        #fixme: report and restart the process
                        addActiveProc(taskName, task)
                    if proc.exitcode is not 0:
                        print("exit code", proc.exitcode)
                        proc.join() # Allow tidyup
                        del self.processes[taskName] # Removed finished items from the dictionary
                        self.addActiveProc(taskName, task)

                        print("new process started")
                        break
                        #returned with error
                        #fixme:report and restart the process
                    if not proc.exitcode:
                        print("exit gracefully")
                        proc.join() # Allow tidyup
                        del self.processes[taskName] # Removed finished items from the dictionary
                        break
            sleep(1)
            if self.printProc:
                print(self.processes)
            #no problem detected in this time interval
        self.stopped=True
