#!/usr/bin/env python3

from iMACS.Tasks import ManagedKafkaTask
from iMACS.IO import ManagedRedis

import json,logging
import multiprocessing as mp
logging.basicConfig(
    format='%(asctime)s %(levelname)-4s %(message)s',
    level=logging.DEBUG,
    datefmt='%Y-%m-%d %H:%M:%S')

from mpi_test_cfg import getConfigure

gen = getConfigure()

fname='test_config.json'
gen.saveAs(fname)

count=mp.Value('d',0)
countlock = mp.Lock()

ctrl=mp.Value('i',1)
ctrlLock = mp.Lock()

sharedNumHit=(count,countlock)
control=(ctrl, ctrlLock)


chlp = ConfigHelper(fname)
cfgItems= chlp.getValue('Managed')
task = eval(cfgItems[1].get('class_name'))(cfgItems[1], sharedControl = control, sharedNumHit=sharedNumHit )
task.start()
