from IO.Kafka import getDetectorData, getGlobalData, KafkaGrabber
from Utils.TimeConvert import timeCvt

def get_pulseId_pc_time_from_global(global_conf,offset):
    task=KafkaGrabber(global_conf,offset)
    consumer=task.getKafkaConsumer()
    for msg in consumer:
        pulseId,pc,_,timeSecond = getGlobalData(msg)
        break
    consumer.close()
    return pulseId,pc,timeSecond[0]

def get_pulseId_from_data(module_conf,offset):
    pass

class pulseId_time():
    def __init__(self,global_conf):
        self.pulseId_cur,_,self.stamp_cur=get_pulseId_pc_time_from_global(global_conf,0)
        self.tc=timeCvt()

    def getOffset(self,pulseId):
        return(self.pulseId_cur-pulseId)

    def local2PulseId(self,local):
        stamp=self.tc.local_to_utc_stamp(local)
        offsetTS=self.stamp_cur-stamp
        if offsetTS<0:
            print("error in kafka data!")
        else:
            offsetPulseId=offsetTS*25
            pulseId=self.pulseId_cur-offsetPulseId
        return pulseId

    def pulseId2Local(self,pulseId):
        offsetPulseId=self.pulseId_cur-pulseId
        if offsetPulseId<0:
            print("error in kafka data!")
        else:
            offsetTS=offsetPulseId/25.0
            ts=self.stamp_cur-offsetTS
            local = self.tc.utc_stamp_to_local(ts)
        return local
    
    def local2utc(self, local):
        return self.tc.local_to_utc_stamp(local)
    
