from Tasks import Task
from kafka import KafkaConsumer, TopicPartition
import IO.Kafka.Data.Detector.EventData as EventData
import IO.Kafka.Data.Global.MetaData as MetaData
import re,time,logging
from IO.Kafka import getDetectorData, getGlobalData
from  Utils.Histogram import Hist2D
from IO.RedisHelper import RedisHelper, getRedisHelper

def getModuleName(conf):
    _topic = conf['topic']
    _pattern = '^BL16-Detector-(Bank\d{2}-Module\d{2})-EventData$'
    _r = re.match(_pattern, _topic)
    _p = None
    if _r is not None:
        _p = _r.group(1)
    return _p

class KafkaMetaData(Task):
    def __init__(self, status, conf, redis_conf, backward=0):
        super().__init__(status)
        if type(conf) is not dict:
            raise Exception('Error: conf must be a dict')
        self.conf = conf
        self.previousPulseId = None
        self.dataType = self.conf['data_type']
        self.backward=backward

        self.consumer = KafkaConsumer(group_id=self.conf['group_id'],
                bootstrap_servers = self.conf['bootstrap_servers'],
                auto_offset_reset = self.conf['auto_offset_reset'],
                enable_auto_commit = self.conf['enable_auto_commit'],
                consumer_timeout_ms = float(self.conf['consumer_timeout_ms']))
        topicPartition =  TopicPartition(self.conf['topic'], 0)
        self.consumer.assign([topicPartition])
        self.consumer.seek_to_end()
        _current_offset = self.consumer.position(topicPartition)
        if _current_offset - self.backward > 0:
            self.consumer.seek(topicPartition, int(_current_offset - self.backward))

        #redis
        self.rds = getRedisHelper(redis_conf)
        #self.redisPath = getRedisPath(conf)

    def getDataType(self):
        return self.dataType

    def run(self):
        _pts = list(self.consumer.assignment())
        #consumer.seek_to_end(_pts[0])
        #consumer.seek(_pts[0], consumer.position(_pts[0]) - 25*60*60)
        dataType = self.getDataType()
        hitRdsTime = time.time()
        startPulseID = 0
        appName = getModuleName(self.conf)
        totCharge = 0

        for msg in self.consumer:
            pulseId, pCharge, timeNano, timeSecond = getGlobalData(msg)
            totCharge += pCharge

            if (time.time()-hitRdsTime)>5.: #every 5 sec

                self.rds.write("/mpi/imacs/proton_charge", str(totCharge))
                # logging.info(f'Empty pulses: {count}/{total}, {count*100/total}%')
                redisTime=time.time()
                logging.info('{}:  accumulated {}'.format(appName, totCharge ) )
                hitRdsTime=time.time()
