import json

class ConfigBase():
    def __init__(self):
        self.config={}

    def __realInit(self, **kwargs):
        for key, value in kwargs.items():
            self.config[key] = value

    def set(self, **kwargs):
        for key, value in kwargs.items():
            if key in self.config:
                self.config[key] = value
            else:
                raise RuntimeError(f'key {key} is not a valid parameter in cfg class {type(self)}')

    def get(self):
        return self.config

class KafkaConfig(ConfigBase):
    def __init__(self):
        super().__init__()
        #set defult paramters
        self._ConfigBase__realInit(auto_offset_reset='earliest', consumer_timeout_ms='inf',\
        enable_auto_commit = True, bootstrap_servers=None, data_type = None, \
        topic = None, group_id = None, seek_type = None )


class Config():
    def __init__(self):
        self.config = {}
        self.kafkaConfig={}
        self.histogramConfig={}
        self.redisConfig={}
        self.kaf

    def setKafka(self, kafka_servers, dataType, topic, group_id, seek_type):
        self.config['auto_offset_reset'] = 'earliest'
        self.config['bootstrap_servers'] = kafka_servers
        self.config['consumer_timeout_ms'] = 'inf'
        self.config['data_type'] = dataType
        self.config['enable_auto_commit'] = True
        self.config['topic'] = topic
        self.config['group_id'] = group_id
        self.config['seek_type']=seek_type

    def setHistogram(self, xBinNum, xrange, yBinNum, yRange):
        self.config['xBinNum'] = xBinNum
        self.config['yBinNum'] = yBinNum
