from IO.RedisHelper import RedisHelper
import multiprocessing as mp
from time import sleep
from Tasks.TaskManager import TaskManager
from IO.Kafka import getDetectorData, getGlobalData, KafkaGrabber
import json
import baseOP
import sys
import numpy as np
import time
import baseComp
import subprocess
import datetime
import glob
from kafka import KafkaConsumer, TopicPartition

def getRunFile(path):
    tmpList=glob.glob(path+"/RUN*")
    data=[]
    for item in tmpList:
        data.append(int(item[-7:]))
    return data


if __name__=="__main__":


    confFile = "testConf.json"
    #confFile = "conf.json"
    with open(confFile,"r") as json_file:
        conf=json.load(json_file)

    #startT0=0
    #startT0=270175028
    #endT0=271306032
    #runNo="RUN0000087"
    #startT0=271523527
    #startT0=270175028
    #endT0=271306032
    #endT0=271666015
    runNo="RUN0000080"

    xmlPath="/home/da/iMACS/online/idf"

    tc=baseOP.timeConvert()
    print("hello")
    save_prepath="/home/da/test"
    database_path="./database"

    #'''
    #startLocal=tc.pulseId2Local(startT0)
    startLocal="2021-01-26T17:30:00"
    startStamp=tc.local_to_utc_stamp(startLocal)
    #endLocal=tc.pulseId2Local(endT0)
    endLocal="2021-01-26T19:25:00"
    endStamp=tc.local_to_utc_stamp(endLocal)
    tofbins=5000
    chunksize=10000
    dataPath=save_prepath+"/"+runNo
    baseOP.createDir(dataPath)
    #'''
    moduleList=[]
    monitorList=[]
    for _item in conf['modules']['detector_modules']:
        if _item.get('enabled') is not None:
            if _item['enabled'] == False:
                print(f'{_item["topic"]} is not enabled, skip.')
                continue
        #print(_item)
        _taskName = baseOP.getModuleName2(_item)
        moduleList.append(_taskName)
    for _item in conf['modules']['monitor_modules']:
        if _item.get('enabled') is not None:
            if _item['enabled'] == False:
                print(f'{_item["topic"]} is not enabled, skip.')
                continue
        if _item["data_type"] == "event":
            _taskName = baseOP.getMonitorName(_item)
            monitorList.append(_taskName)
    
    #start merge detector.nxs
    savePath="/home/da/"+runNo
    baseOP.createDir(savePath)
    #write public information
    pubDict={"start_time_utc":[bytes(startLocal,encoding="utf8")],
             "end_time_utc":[bytes(endLocal,encoding="utf8")],
             "start_time_tai":[bytes(str(startStamp),encoding="utf8")],
             "end_time_tai":[bytes(str(endStamp),encoding="utf8")],
             "beamline":[b"BL16"],
             "run_no":[str.encode(runNo)]}
    
    run = baseComp.nxsWrite()
    run.mergeHistModules(dataPath,pubDict,moduleList,monitorList)

    #'''
    _cmd="cp "+dataPath+"/detector.nxs "+savePath
    subprocess.check_call(_cmd, shell=True)
    transPath1="da@10.1.37.246:/data/mpi/BL16-commissioning/"
    transPath2="root@10.1.231.231:/userData/BL16/BL16-commissioning/"

    _cmd="scp -r "+savePath+" "+transPath1
    subprocess.check_call(_cmd, shell=True)
    _cmd = 'scp complete  '+transPath1+runNo
    subprocess.check_call(_cmd, shell=True)
    _cmd="scp -r "+savePath+" "+transPath2
    subprocess.check_call(_cmd, shell=True)
    _cmd = 'scp complete  '+transPath2+runNo
    subprocess.check_call(_cmd, shell=True)

    _cmd = 'rm -rf '+savePath
    subprocess.check_call(_cmd, shell=True)
    #'''
    f=open(database_path+"/"+runNo, "w")
    f.close()
    time.sleep(10)
