import flatbuffers
from kafka import KafkaConsumer, TopicPartition
import IO.Kafka.Data.Detector.EventData as EventData
import IO.Kafka.Data.Global.MetaData as MetaData
import numpy as np

def getDetectorData(msg):
    data = EventData.EventData.GetRootAsEventData(msg.value, 0)
    pulseId = data.PulseId()
    tofs = data.TofAsNumpy()
    pids = data.PosAsNumpy()
    return pulseId, tofs, pids

def getGlobalData(msg):
    data = MetaData.MetaData.GetRootAsMetaData(msg.value, 0)
    pulseId = data.PulseId()
    deviceId = data.DeviceId()
    deviceName = data.DeviceName()
    value = data.ValueAsNumpy()
    timeNano = data.TimeNanoAsNumpy()
    timeSecond = data.TimeSecondAsNumpy()
    return pulseId, value, timeNano, timeSecond

class KafkaGrabber():
    def __init__(self, conf, backward=0):
        if type(conf) is not dict:
            raise Exception('Error: conf must be a dict')
        self.conf = conf
        self.previousPulseId = None
        self.dataType = self.conf['data_type']
        self.backward=backward

    def getKafkaConsumer(self,stamp):
        consumer = KafkaConsumer(group_id=self.conf['group_id'],
                bootstrap_servers = self.conf['bootstrap_servers'],
                auto_offset_reset = self.conf['auto_offset_reset'],
                enable_auto_commit = self.conf['enable_auto_commit'],
                consumer_timeout_ms = float(self.conf['consumer_timeout_ms']))
        topicPartition =  TopicPartition(self.conf['topic'], 0)
        consumer.assign([topicPartition])
        #consumer.seek_to_end()
        _current_offset = consumer.position(topicPartition)
        if _current_offset - self.backward > 0:
            consumer.seek(topicPartition, int(_current_offset - self.backward))
        return consumer

    def getKafkaConsumerFromBegin(self):
        consumer = KafkaConsumer(group_id=self.conf['group_id'],
                bootstrap_servers = self.conf['bootstrap_servers'],
                auto_offset_reset = self.conf['auto_offset_reset'],
                enable_auto_commit = self.conf['enable_auto_commit'],
                consumer_timeout_ms = float(self.conf['consumer_timeout_ms']))
        topicPartition =  TopicPartition(self.conf['topic'], 0)
        consumer.assign([topicPartition])
        consumer.seek_to_beginning()
        _current_offset = consumer.position(topicPartition)
        if self.backward - _current_offset > 0:
            consumer.seek(topicPartition, int(_current_offset + self.backward))
        return consumer


    def getDataType(self):
        return self.dataType

    def get(self, pars):
        pass

    def set(self):
        pass

