import time, datetime
from IO.RedisHelper import RedisHelper
import baseComp
from IO.Kafka import getDetectorData, getGlobalData, KafkaGrabber
import re
import os
import numpy as np
import subprocess
import json

def getPulseInfo(runno):
    fname="./runlog/"+runno
    with open(fname, "r") as conf_file:
        conf=json.load(conf_file)
    startPulseId=conf["startPulseId"]
    endPulseId=conf["endPulseId"]
    return startPulseId,endPulseId

def getRuntoMerge():
    recList=[]
    complete=os.listdir("./complete")
    db=os.listdir("./runlog")
    for item in db:
        if item[:3]=="RUN" and item not in complete:
            recList.append(item)
    return recList

def createDir(path):
    if os.path.exists(path):
        pass
    else:
        os.mkdir(path)


class kafkaRec():
    def __init__(self,confFile):
        with open(confFile,"r") as json_file:
            self.conf=json.load(json_file)
        recConf=self.conf["rec_configure"]
        self.rawPath=recConf["rawdata_path"]
        self.nxsPath=recConf["complete_path"]
        self.tofs=recConf["tofbins"]
        self.chunksize=recConf["chunksize"]
        self.dbPath=recConf["db_path"]
        self.dbIDPath=recConf["db_id_path"]
        self.cloudPath=recConf["cloud_path"]
        self.expPath=recConf["local_expinfo_path"]
        self.localdbPath=recConf["local_completeinfo_path"]
        #self.startT0=startT0
        #self.endT0=endT0
        self.myDict={} 

    def getRedisHelper(redis_conf):
        _mode = redis_conf['mode'].lower()
        _password = redis_conf['password']
        _servers = []
        for _item in redis_conf['servers']:
            _servers.append((_item['host'], _item['port']))
        if _mode == 'standalone':
            return RedisHelper(_servers[0], _password, 10)
        elif _mode == 'sentinel':
            return RedisHelper(_servers, _password, 10, master_name=redis_conf['master_name'])
        else:
            raise Exception(f'Redis mode not supported: {_mode}')
    
    def connectRedis(self,name):
        redis_conf=self.conf[name]
        return self.getRedisHelper(redis_conf)


    def getPulseInfoFromFile(self,runno):
        fname=self.expPath+"/"+runno
        with open(fname, "r") as conf_file:
            conf=json.load(conf_file)
        self.startT0=conf["startPulseId"]
        self.endT0=conf["endPulseId"]


    def getPusleInfoFromRedis(self):
        pass

    def getPublicInfo(self,runno):
        tc=timeConvert()
        startLocal=tc.pulseId2Local(self.startT0)
        startStamp=tc.local_to_utc_stamp(startLocal)
        endLocal=tc.pulseId2Local(self.endT0)
        endStamp=tc.local_to_utc_stamp(endLocal)
        pubDict={"start_time_utc":[bytes(startLocal,encoding="utf8")],
             "end_time_utc":[bytes(endLocal,encoding="utf8")],
             "start_time_tai":[bytes(str(startStamp),encoding="utf8")],
             "end_time_tai":[bytes(str(endStamp),encoding="utf8")],
             "beamline":[b"BL16"],
             "run_no":[str.encode(runno)]}
        return pubDict

    def mergeNxs(self,runno,dataMode):
        savepath=self.nxsPath+"/"+runno
        createDir(savepath)
        pubInfo=self.getPublicInfo(runno)
        moduleList=self.myDict.keys()
        run = baseComp.nxsWrite()
        run.mergeModules(savepath,pubInfo,moduleList,dataMode)

    def getName(self,confInfo,typename):
        _topic = confInfo['topic']
        if typename=="monitor":
            num=_topic.find("Monitor")
            _p="monitor"+_topic[num+7:num+9]
        else:
            num=_topic.find("Bank")
            _p="module1"+_topic[num+4:num+6]
            num=_topic.find("Module")
            _p+=_topic[num+6:num+8]
        return _p

    def offlineHistDetector(self,conf,mname,t1,t2):
        tc=timeConvert()
        offset=tc.getOffset(self.startT0)
        task = KafkaGrabber(conf,offset)
        consumer=task.getKafkaConsumer()
        nxsfile=self.rawPath+"/"+mname+"_hist.nxs"
        run = baseComp.nxsWrite(self.nxsPath,self.tofs)
        run.recHistModule(mname,consumer,t1,t2)
        print("finish online ",mname)

    def getTask(self,dataMode,lineMode,name,runno):
        #mode=hist:only hist data
        #mode=all:hist and evt data
        #lineMode is online or offline
        createDir(self.rawPath+"/"+runno)
        nodeName="detector_modules"
        if name[:7]=="monitor":
            nodeName='monitor_modules'
        for _item in self.conf['modules'][nodeName]:
            if _item.get('enabled') is not None:
                if _item['enabled'] == False:
                    print(f'{_item["topic"]} is not enabled, skip.')
                    continue
                if _item["data_type"] == "event":
                    _taskName = self.getName(_item,name)
                    #print(_taskName)
            if lineMode=="offline":
                if dataMode == "hist":
                    self.myDict[_taskName]=[self.offlineHistDetector,(_item,_taskName,self.startT0,self.endT0)]
                else:
                    pass
                    #self.myDict[_taskName]=[offlineDetector,(_item,_taskName,dataPath,tofbins,startT0,endT0)]
            else:
                pass
                #self.myDict[_taskName]=[onlineDetector,(_item,_taskName,dataPath,tofbins,startT0,endT0)]


    def onlineDetector(conf,mname,prepath,tofs,chunksize,t1,t2):
        print("start online: ",mname)
        print("start offset: ",mname,offset)
        task = KafkaGrabber(conf, offset)
        consumer=task.getKafkaConsumer()
        nxsfile=prepath+"/"+mname+".nxs"
        run = baseComp.nxsWrite()
        if mname[:6]=="module":
            run.recSingleModule(prepath,mname,tofs, chunksize, consumer,t1,t2)
        else:
            print("start rec monitor")
            run.recSingleMonitor(prepath,mname,tofs,consumer,t1,t2)
        #_cmd = 'scp ./complete/complete_'+mname+" "+prepath
        #subprocess.check_call(_cmd, shell=True)
        print("finish online ",mname)


    def sendData(self,runno):
        expFile="./runlog/"+runno
        dataPath=self.nxsPath+"/"+runno
        _cmd="cp "+expFile+" "+dataPath
        subprocess.check_call(_cmd, shell=True)

        _cmd="scp -r "+dataPath+" "+self.cloudPath
        subprocess.check_call(_cmd, shell=True)
        #_cmd = 'scp complete  '+transPath1+runNo
        #subprocess.check_call(_cmd, shell=True)
        _cmd="scp -r "+dataPath+" "+self.dbPath
        subprocess.check_call(_cmd, shell=True)
        
        f=open(runno, "w")
        f.close()
        _cmd="scp "+runno+" "+self.dbIDPath
        subprocess.check_call(_cmd, shell=True)
        _cmd="rm -rf "+runno
        subprocess.check_call(_cmd, shell=True)




class timeConvert():
    def __init__(self):
        self.local_format="%Y-%m-%dT%H:%M:%S"

    def getCurrPulseIdSecond(self):
        confFile = "conf.json"
        with open(confFile,"r") as json_file:
            conf=json.load(json_file)
        item=conf["modules"]["global_modules"]
        #print(item)
        task = KafkaGrabber(item[0])
        consumer=task.getKafkaConsumer()
        for msg in consumer:
            pulseId,_,_,timeSecond = getGlobalData(msg)
            break
        consumer.close()
        return pulseId,timeSecond[0]

    def utc_stamp_to_local(self,seconds):
        utc_time=datetime.datetime.utcfromtimestamp(seconds)
        local=utc_time+datetime.timedelta(hours=8)
        local=local.strftime(self.local_format)
        return local

    def local_to_utc_stamp(self,local):
        dt=datetime.datetime.strptime(local, self.local_format)
        dt=dt+datetime.timedelta(hours=-8)
        stamp=time.mktime(dt.timetuple())
        return stamp
    
    def local2PulseId(self,local):
        ts = self.local_to_utc_stamp(local)
        curPulseId,curTime=self.getCurrPulseIdSecond()
        offsetTS=curTime-ts
        if offsetTS<0:
            print("error in kafka data!")
        else:
            offsetPulseId=offsetTS*25
            pulseId=curPulseId-offsetPulseId
        return pulseId

    def pulseId2Local(self, pulseId):
        curPulseId,curTime=self.getCurrPulseIdSecond()
        offsetPulseId=curPulseId-pulseId
        if offsetPulseId<0:
            print("error in kafka data!")
        else:
            offsetTS=offsetPulseId/25.0
            ts=curTime-offsetTS
            local = self.utc_stamp_to_local(ts)
        return local

    def getOffset(self,pulseId):
        curPulseId,curTime=self.getCurrPulseIdSecond()
        offset=curPulseId-pulseId
        return offset
