#!/usr/bin/env python3

from Utils.Histogram import Hist2D
import numpy as np
import time

xbin=4000
ybin=500

hist = Hist2D(xbin,ybin,[[0,1],[0,1]])
histSlow = Hist2D(xbin,ybin,[[0,1],[0,1]])

eventSize = 1000
data=np.random.random([2,eventSize])

for i in range(10):
    now = time.time()
    hist.fill(data[0],data[1])
    els = time.time()-now

    now = time.time()
    histSlow.slowfill(data[0],data[1])
    elsSlow = time.time()-now

    np.testing.assert_array_equal(hist.hist, histSlow.hist)

    print('{} events, fast fill {}ms ({}us per event), slow fill {}ms'.format(eventSize, els*1e3, els*1e6/eventSize, elsSlow*1e3) )
