#!/usr/bin/env python3

from IO.Kafka import getDetectorData, getGlobalData, KafkaGrabber
from time import sleep
import multiprocessing as mp
from Tasks.TaskManager import TaskManager


def onlineDetector(conf):
    task = KafkaGrabber(queue=[1,2,3], conf=conf['detector_modules'][1])
    consumer = kafkaGrabber.getKafkaConsumer()
    dataType = kafkaGrabber.getDataType()
    for msg in consumer:
       tofs, pids = getDetectorData(msg)
       print(tofs.shape, pids.shape)

conf={'detector_modules':[{'data_type':'meta','bootstrap_servers':['10.1.29.120:9092'], 'auto_offset_reset':'earliest','group_id':'mpi_das', 'topic':'PulseBeam', 'enable_auto_commit': True, 'consumer_timeout_ms':5000}, {'data_type':'event','bootstrap_servers':['10.1.36.82:9092'], 'auto_offset_reset':'earliest','group_id':'das_test', 'topic':'BL16-Detector-Bank07-Module01-EventData', 'enable_auto_commit': True, 'consumer_timeout_ms':5000}]}

if __name__ == '__main__':
    mp.set_start_method('fork')

    tasks = {'det': [onlineDetector, ('conf',)]}
    man = TaskManager(tasks)
    print("main thread sleeping")
    sleep(10)
    man.stopProc()
    print ('Main exit')
