from .Task import Task
import re,time,logging
from iMACS.IO import ManagedRedisPeriodicRW
from iMACS.Config import ConfigHelper
from time import sleep
import numpy as np
import json, logging
import time, datetime

end_path = "/mpi/imacs/last_run" #with control
runStartTime = "/mpi/imacs/start_time"
runEndTime = "/mpi/imacs/end_time"


class ManagedRedisExpCfg(Task, ManagedRedisPeriodicRW):
    def __init__(self, cfg, sharedControl, sharedNumHit, sharedAccumulated, lastExitCode=0):
        Task.__init__(self, sharedControl, sharedNumHit, sharedAccumulated, None, None, lastExitCode)
        self.cfghelp=ConfigHelper(cfg)
        self.curExpCfgDict = {} #current setting
        self.redisData = None #from user GUI
        self.dectCnt = 0.
        self.dectCntRate = 0.
        self.monitorCnt = 0.
        self.monitorCntRate = 0.
        self.runStartTime =  0
        self.elapsedTime=0
        self.runLength = 0.
        self.progress=0
        self.running = False

        if type(cfg) is not dict:
            raise Exception('ManagedRedisExpCfg.__init__ cfg must be a dict')

    def realInit(self):
        if not self.init:
            ManagedRedisPeriodicRW.__init__(self, self.cfghelp.cfg)
            self.init = True

    def realRun(self):
        pass

    def startRun(self):
        logging.info(f'run started: {self.curExpCfgDict}')
        self.running=True
        with self.accumulated.get_lock():
            self.accumulated.value = 0

        with self.numhit.get_lock():
            self.numhit.value = 0

        with self.control.get_lock():
            self.control.value = 1

        self.runStartTime=time.time()

        now = datetime.datetime.now()
        self.write(runStartTime, str(now.strftime('%Y-%m-%d %H:%M:%S')))
        self.runLength = float(self.curExpCfgDict['endValue'])
        end = now + datetime.timedelta(seconds=self.runLength)
        self.write(runEndTime, str(end.strftime('%Y-%m-%d %H:%M:%S')))
        #fixme: write database


    def stopRunClearData(self):
        logging.info('clearing run data')
        self.running=False
        #let other component to act
        with self.control.get_lock():
            self.control.value = 2

        self.dectCnt = 0.
        self.dectCntRate = 0.
        self.monitorCnt = 0.
        self.monitorCntRate = 0.

        #update last_run
        self.write(end_path, self.curExpCfgDict['runNo'])

        sleep(1) #fixme: gives 1 sec. to act

        with self.control.get_lock():
            self.control.value = 0

        with self.accumulated.get_lock():
            self.accumulated.value = 0

        with self.numhit.get_lock():
            self.numhit.value = 0

    def endOfRunAction(self):
        logging.info('endOfRunAction')
        # #fixme: write database
        # toDur = {}
        # toDur['runNo']=self.curExpCfgDict['runNo']
        # toDur['startPulseId']=startPulseId
        # toDur['endPulseId']=int(startPulseId + (time.time()-self.runStartTime)*25)
        # with open(str(toDur['runNo']), 'a') as file:
        #     file.write(json.dumps(toDur))
        # logging.info('overright durong info {}'.format(toDur))

    def pauseRun(self):
        if len(self.curExpCfgDict)!=0:
            logging.info('run paused')
        with self.control.get_lock():
            self.control.value = 0

        #fixme: write database

    def updateRunStatistics(self):
        if self.control.value==1:
            if self.runStartTime !=0:
                self.elapsedTime=time.time()-self.runStartTime
            else:
                self.elapsedTime=0
            self.dectCnt = self.numhit.value
            self.monitorCnt = self.accumulated.value
            if self.elapsedTime > 0:
                self.dectCntRate = self.dectCnt/self.elapsedTime
                self.monitorCntRate = self.monitorCnt/self.elapsedTime
                if self.runLength!=0.:
                    self.progress = self.elapsedTime/self.runLength*100
                else:
                    return
                if self.progress>100:
                    self.progress=100

    def run(self):
        self.realInit()
        self.startPeriodicRW()
        while True:
            sleep(1)
            #Pause run
            if self.redisData is None or self.redisData==b'null':
                self.pauseRun()
                continue

            runInfo = json.loads(self.redisData.decode())

            #when first start, curExpCfgDict is empty
            #assign it to runinfo to avoid starting this run
            if len(self.curExpCfgDict)==0:
                self.curExpCfgDict=runInfo
                continue



            #start new run
            if runInfo.get('runNo') != self.curExpCfgDict.get('runNo'):
                self.stopRunClearData()
                self.curExpCfgDict=runInfo
                print(self.curExpCfgDict)
                self.startRun()
            #if overtime
            elif time.time()-self.runStartTime > self.runLength:
                print('overtime')
                self.elapsedTime=self.runLength
                self.progress = 100
                if self.running==True:
                    self.stopRunClearData()
                    self.endOfRunAction()
                else:
                    continue
            else:
                print('update statistics')
                self.updateRunStatistics()
