from iMACS.IO import ManagedRedis
from iMACS.Config import ConfigHelper
import time, threading
#master_name, ip_port, socket_timeout, db,
#redisPath, mode, asNumArray, update_interval_sec

class  ManagedRedisPeriodicRW( ManagedRedis):
    def __init__(self, redisRWCfg):
        self.target = None
        if redisRWCfg is None:
            return
        super().__init__( redisRWCfg)
        cfg = ConfigHelper(redisRWCfg)

        self.redisPath = cfg.getValue('redisPath')
        self.mode = cfg.getValue('mode')
        if self.mode!='r' and self.mode!='w':
            raise Exception('mode should be either w or r')

        self.asNumArray = cfg.getValue('asNumArray')
        self.interval_sec = cfg.getValue('update_interval_sec')
        self.keepRunning = False
        self.lock = threading.Lock()


    def startPeriodicRW(self):
        if self.target is not None:
            self.keepRunning = True
            self.periodictTask()

    def stopPeriodicRW(self):
        if self.target is not None:
            self.keepRunning = False


    def periodictTask(self):
        if self.target is not None:
            with self.lock:
                if self.mode == 'r':
                    if self.asNumArray:
                        self.target =  self.readNumpyArray(self.redisPath)
                    else:
                        self.target =  self.read(self.redisPath)
                else:
                    if self.asNumArray:
                        self.writeNumpyArray(self.redisPath, self.target )
                    else:
                        self.write(self.redisPath, self.target)
            if self.keepRunning:
               threading.Timer(self.interval_sec, self.periodictTask).start()

            print(f'Integral is {self.target.sum()}')
