#!/usr/bin/env python3

from iMACS.Tasks import ManagedKafkaTask, ManagedRedisExpCfg
from iMACS.IO import ManagedRedis
from iMACS.Config import ConfigHelper
from iMACS.Tasks import TaskManager

import json,logging
import multiprocessing as mp
from time import sleep

logging.basicConfig(
    format='%(asctime)s %(levelname)-4s %(message)s',
    level=logging.INFO,
    datefmt='%Y-%m-%d %H:%M:%S')

from mpi_test_cfg import getConfigure

gen = getConfigure()

fname='test_config.json'
gen.saveAs(fname)

detCount=mp.Value('d',0)
monitorCount=mp.Value('d',0)
totPCharge=mp.Value('d',0)
ctrl=mp.Value('i', 0)
curPulse=mp.Value('i', 0)


tasks = {}
chlp = ConfigHelper(fname)
cfgItems= chlp.getValue('Managed')
logging.info(cfgItems[1])
ctl = eval(cfgItems[1].get('class_name'))(cfgItems[1], sharedControl = ctrl, sharedNumHit=detCount, sharedAccumulated=monitorCount, sharedState=curPulse )
tasks['redis']=ctl
logging.info(f'started item2')


for i in range(2,32):
    det = eval(cfgItems[i].get('class_name'))(cfgItems[i], sharedControl = ctrl, sharedNumHit=detCount )
    name=f'det{i-1}'
    tasks[name]=det
    logging.info(f'started item{i}')

monitor = eval(cfgItems[32].get('class_name'))(cfgItems[32], sharedControl = ctrl, sharedNumHit=monitorCount )
tasks['monitor']=monitor
cn=cfgItems[32].get('class_name')
logging.info(f'started monitor {cn}')

glb = eval(cfgItems[33].get('class_name'))(cfgItems[33], sharedState=curPulse) #fixme
tasks['glb']=glb
cn=cfgItems[33].get('class_name')
logging.info(f'started globl {cn}')

man = TaskManager(tasks)
logging.info("main thread looping")


while True:
    # with ctrlLock:
    #     if ctrl.value==1:
    #         ctrl.value = 0
    #     else:
    #         ctrl.value = 1
    logging.info(f'ctrl {ctrl.value}, total detector {detCount.value}, total monitor {monitorCount.value}')
    sleep(1)

man.stopProc()
print ('Main exit')
