from mantid.simpleapi import *
import threading
import numpy as np
import time

class monitorIO(threading.Thread):
    def __init__(self,neonRedis, refreshtime,tofbins):
        super(monitorIO, self).__init__()

        self.refreshtime=refreshtime
        self.neonRedis=neonRedis
        self.histPath="/MPI/workspace/monitor1/value"
        self.instPath="../writeIDF/idf/MPI_Definition_monitor01.xml"
        self.monitor='monitor1'
        self.sendPath="/mpi/mantid/"+self.monitor
        self.tofs=[]

        self.tofbins=tofbins
        step=40000/tofbins
        for i in range(tofbins):
            self.tofs.append(i*step)
        self.tofs=np.array(self.tofs)


    def processWS(self):
        CreateWorkspace(OutputWorkspace=self.monitor, DataX=self.tofs, DataY=self.value, NSpec=1, UnitX='TOF', VerticalAxisUnit='SpectraNumber')
        LoadInstrument(Workspace=self.monitor, Filename=self.instPath, RewriteSpectraMap='True')
        ConvertToPointData(InputWorkspace=self.monitor, OutputWorkspace=self.monitor)
        ConvertUnits(InputWorkspace=self.monitor, OutputWorkspace=self.monitor+"_w", Target='Wavelength', EMode='Elastic', AlignBins = True)

    def sendData(self,ws, dataX):
        name=mtd[ws]
        y=name.readY(0)
        x=name.readX(0)
        path=self.sendPath+"/"+dataX
        self.neonRedis.writeNumpyArray(path,x)
        path=self.sendPath+"/"+dataX+"_counts"
        self.neonRedis.writeNumpyArray(path,y)


    def sendXYimage(self):
        counts=[]
        xaxis=[]
        yaxis=[]
        name=mtd[self.monitor]
        for j in range(name.getNumberHistograms()):
            counts.append(sum(name.readY(j)))
            _pos=name.getDetector(j).getRelativePos()
            xaxis.append(_pos.X()*1000)
            yaxis.append(_pos.Y()*1000)
        xaxis=list(set(xaxis))
        yaxis=list(set(yaxis))
        xaxis.sort()
        yaxis.sort()
        nx=len(xaxis)
        ny=len(yaxis)
        xaxis=np.array(xaxis)
        yaxis=np.array(yaxis)
        self.neonRedis.writeNumpyArray(self.sendPath+"/xy_image/x",xaxis)
        self.neonRedis.writeNumpyArray(self.sendPath+"/xy_image/y",yaxis)
        _tmp=np.reshape(counts, (ny,nx))
        self.neonRedis.writeNumpyArray(self.sendPath+"/xy_image/value", _tmp)



    def process(self):
        try:
            tmp = self.neonRedis.readNumpyArray(self.histPath)
            tmp=tmp.T
            self.value=tmp
        except:
            self.value=np.zeros((1,self.tofbins))
        self.processWS()
        self.sendData(self.monitor+"_w","wave")
        self.sendData(self.monitor,"tof")

    def run(self):
        while True:
            self.process()
            time.sleep(10)
