import moduleIO
#import redis
from IO.RedisHelper import RedisHelper
import sys
import json


def getRedisHelper(redis_conf):
    _mode = redis_conf['mode'].lower()
    _password = redis_conf['password']
    _servers = []
    for _item in redis_conf['servers']:
        _servers.append((_item['host'], _item['port']))

    if _mode == 'standalone':
        return RedisHelper(_servers[0], _password, 10)
    elif _mode == 'sentinel':
        return RedisHelper(_servers, _password, 10, master_name=redis_conf['master_name'])
    else:
        raise Exception(f'Redis mode not supported: {_mode}')


if __name__ == '__main__':
    with open('redisConf.json',"r") as json_file:
        conf = json.load(json_file)
    rds=getRedisHelper(conf)

    myThread=[]
    
    moduleNum=int(sys.argv[1])
    tofs=int(sys.argv[2])
    if int((moduleNum-10000)/100)==7 or int((moduleNum-10000)/100)==8:
        tubeLen=0.3
    else:
        tubeLen=0.5


    totPidNum=int(tubeLen/0.005*8)
    #print(totPidNum)
    # ======Try to connect NEON server
    name="module"+str(moduleNum)
    myThread=moduleIO.moduleIO(rds, 1, name,totPidNum,tofs)
    
    myThread.start()
    myThread.join()

