from IO.RedisHelper import RedisHelper
import json
import os



def getRedisHelper(redis_conf):
    mode = redis_conf['mode'].lower()
    password = redis_conf['password']
    servers = []
    for item in redis_conf['servers']:
        servers.append((item['host'], item['port']))
    if mode == 'standalone':
        return RedisHelper(servers[0], password, 10)
    elif mode == 'sentinel':
        return RedisHelper(servers, password, 10, master_name=redis_conf['master_name'])
    else:
        raise Exception(f'Redis mode not supported: {mode}')

def getModuleBankName(module_conf):
    topic = module_conf['topic']
    num=topic.find("Monitor")
    if num==-1:
        num=topic.find("Bank")
        b=topic[num:num+6].lower()
        p="module1"+topic[num+4:num+6]
        num=topic.find("Module")
        p+=topic[num+6:num+8]
    else:
        p="monitor"+topic[num+7:num+9]
        b=topic[num:num+9].lower()
    return p,b


def getModulesConf(conf):
    moduleDict={}
    nameList=["detector_modules","monitor_modules"]
    #nameList=["detector_modules"]
    for name in nameList:
        #try:
        for item in conf['modules'][name]:
            if item.get('enabled') is not None:
                if item['enabled'] == False:
                    print(f'{item["topic"]} is not enabled, skip.')
                    continue
                if item["data_type"] == "event":
                    mname,_ = getModuleBankName(item)
                    moduleDict[mname]=item
    return moduleDict

def getModuleGroupMatch(conf):
    myDict={}
    #nameList=["detector_modules"]
    nameList=["detector_modules","monitor_modules"]
    for name in nameList:
        for item in conf['modules'][name]:
            if item.get('enabled') is not None:
                if item['enabled'] == False:
                    print(f'{item["topic"]} is not enabled, skip.')
                    continue
                if item["data_type"] == "event":
                    mname,bname = getModuleBankName(item)
                    groupName=findGroup(bname,conf["online_configure"]["groupInfo"])
                    #findGroup(mname,)
                    myDict[mname]=groupName
    return myDict

def findGroup(name,group_conf):
    for key,values in group_conf.items():
        if name in values:
            return key
    return None

def getGroupDict(conf):
    dic = getModuleGroupMatch(conf)
    tmp={}
    for key,val in dic.items():
        tmp[val]=key
    bList=tmp.keys()
    res={}
    for bank in bList:
        tmp=[]
        for item in dic:
            if dic[item]==bank:
                tmp.append(item)
        res[bank]=tmp
    return res



def getConf(fname):
    judge=os.path.isfile(fname)
    if judge:
        with open(fname, 'r') as _f:
            return json.load(_f)
    else:
        print("can't find file")
        return 0

def getRunList2Rec(rec_conf):
    recList=[]
    minRun=rec_conf["minRun"]
    maxRun=rec_conf["maxRun"]
    cmpPath=rec_conf["complete_local_path"]
    logPath=rec_conf["cxx_local_path"]
    try:
        complete=os.listdir(cmpPath)
    except:
        os.mkdir(cmpPath)
        complete=[]
    try:
        explog=os.listdir(logPath)
    except:
        os.mkdir(logPath)
        explog=[]
    for item in explog:
        if item[:3]=="RUN" and item not in complete:
            if int(item[-7:])>minRun and int(item[-7:])<maxRun:
                recList.append(item)
    return recList

