import json
import baseOP
import h5py
from IO.Kafka import getDetectorData, getGlobalData, KafkaGrabber
import numpy as np

class iMACSTest():
    def __init__(self,confFile):
        with open(confFile,"r") as json_file:
            self.conf=json.load(json_file)
                
    def getPath(self,runno):
        self.dbPath=self.conf["rec_configure"]["db_path"]
        self.dbIDPath=self.conf["rec_configure"]["db_id_path"]
        self.cloudPath=self.conf["rec_configure"]["cloud_path"]
        self.expPath=self.conf["rec_configure"]["local_expinfo_path"]
        self.localdbPath=self.conf["rec_configure"]["local_completeinfo_path"]
        self.rawPath=self.conf["rec_configure"]["rawdata_path"]+"/"+runno
        self.nxsPath=self.conf["rec_configure"]["complete_path"]+"/"+runno


    def testReadEvtNXS(self,name,num):
        fname=self.rawPath+"/"+name+"_evt_"+str(num)+".nxs"
        f0=h5py.File(fname,"r")
        pids = f0["csns/instrument/"+name+"/event_pixel_id"]
        tofs = f0["csns/instrument/"+name+"/event_time_of_flight"]
        pulse = f0["csns/instrument/"+name+"/event_pulse_time"]
        return pids,tofs,pulse

    def testReadHistNXS(self,name):
        fname=self.nxsPath+"/detector.nxs"
        f0=h5py.File(fname,"r")
        hist=f0["csns/instrument/"+name+"/histogram_data"]
        return hist

    def testModulesCurPulseId(self):
        myDict=baseOP.getModuleDictFromConf(self.conf)
        for item in myDict:
            kafkaconf=myDict[item]
            task = KafkaGrabber(kafkaconf,0)
            consumer=task.getKafkaConsumer()
            print("start with ",item)
            for msg in consumer:
                pulseId, tofs, pids = getDetectorData(msg)
                print("pulse Id: ",pulseId)
                break
            consumer.close()

    def testKafka(self,name):
        myDict=baseOP.getModuleDictFromConf(self.conf)
        kafkaconf=myDict[name]
        task = KafkaGrabber(kafkaconf,0)
        consumer=task.getKafkaConsumer()
        print(consumer)
        for msg in consumer:
            pulseId, tofs, pids = getDetectorData(msg)
            print(pulseId)
        consumer.close()

    def checkOffset(self,t1):
        pass


    def testRebin(self,name):
        data=self.testReadHistNXS(name)
        val=np.array(data)
        xsize,ysize=val.shape
        xrebinFactor=1
        yrebinFactor=5
        b=ysize//yrebinFactor
        res=val.reshape(-1,xrebinFactor,b,yrebinFactor).sum((-1,-3))
        return res

