
import multiprocessing as mp
from abc import ABC, abstractmethod

class Task(ABC, mp.Process):
    #sharedControl, sharedData are objects of multiprocessing.Array
    def __init__(self, sharedControl=None, sharedData=None, slavePipe=None, masterPipe=None, lastExitCode=0):
        mp.Process.__init__(self)
        self.control = sharedControl
        self.data = sharedData
        self.lastExitCode = lastExitCode
        self.init = False

    @abstractmethod
    def realinit(self):
        pass

    @abstractmethod
    def run(self):
        pass

#This is an example class
class ExampleTask(Task):
    def __init__(self):
        super().__init__()

    @abstractmethod
    def realinit(self):
        self.init = True

    @abstractmethod
    def run(self):
        if not self.init:
            realinit()

class EpicsListener(Task):
    def __init__(self, status):
        super().__init__(status)
        pass

class EpicsWriter(Task):
    def __init__(self, status):
        super().__init__(status)
        pass

class RedisTask(Task):
    def __init__(self, status):
        super().__init__(status)
        pass

class DataBaseTask(Task):
    def __init__(self, status):
        super().__init__(status)
        pass
